/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.util.BroadcastHelper;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.joda.time.Instant;
import scala.Tuple2;

class MultiDoFnFunction<InputT, OutputT>
implements PairFlatMapFunction<Iterator<WindowedValue<InputT>>, TupleTag<?>, WindowedValue<?>> {
    private final DoFn<InputT, OutputT> mFunction;
    private final SparkRuntimeContext mRuntimeContext;
    private final TupleTag<OutputT> mMainOutputTag;
    private final Map<TupleTag<?>, BroadcastHelper<?>> mSideInputs;

    MultiDoFnFunction(DoFn<InputT, OutputT> fn, SparkRuntimeContext runtimeContext, TupleTag<OutputT> mainOutputTag, Map<TupleTag<?>, BroadcastHelper<?>> sideInputs) {
        this.mFunction = fn;
        this.mRuntimeContext = runtimeContext;
        this.mMainOutputTag = mainOutputTag;
        this.mSideInputs = sideInputs;
    }

    public Iterable<Tuple2<TupleTag<?>, WindowedValue<?>>> call(Iterator<WindowedValue<InputT>> iter) throws Exception {
        ProcCtxt ctxt = new ProcCtxt(this.mFunction, this.mRuntimeContext, this.mSideInputs);
        this.mFunction.startBundle((DoFn.Context)ctxt);
        ctxt.setup();
        return ctxt.getOutputIterable(iter, this.mFunction);
    }

    private class ProcCtxt
    extends SparkProcessContext<InputT, OutputT, Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final Multimap<TupleTag<?>, WindowedValue<?>> outputs;

        ProcCtxt(DoFn<InputT, OutputT> fn, SparkRuntimeContext runtimeContext, Map<TupleTag<?>, BroadcastHelper<?>> sideInputs) {
            super(fn, runtimeContext, sideInputs);
            this.outputs = LinkedListMultimap.create();
        }

        @Override
        public synchronized void output(OutputT o) {
            this.outputs.put((Object)MultiDoFnFunction.this.mMainOutputTag, (Object)this.windowedValue.withValue(o));
        }

        @Override
        public synchronized void output(WindowedValue<OutputT> o) {
            this.outputs.put((Object)MultiDoFnFunction.this.mMainOutputTag, o);
        }

        @Override
        public synchronized <T> void sideOutput(TupleTag<T> tag, T t) {
            this.outputs.put(tag, (Object)this.windowedValue.withValue(t));
        }

        @Override
        public <T> void sideOutputWithTimestamp(TupleTag<T> tupleTag, T t, Instant instant) {
            this.outputs.put(tupleTag, (Object)WindowedValue.of(t, (Instant)instant, (Collection)this.windowedValue.getWindows(), (PaneInfo)this.windowedValue.getPane()));
        }

        @Override
        protected void clearOutput() {
            this.outputs.clear();
        }

        @Override
        protected Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> getOutputIterator() {
            return Iterators.transform(this.outputs.entries().iterator(), (Function)new Function<Map.Entry<TupleTag<?>, WindowedValue<?>>, Tuple2<TupleTag<?>, WindowedValue<?>>>(){

                public Tuple2<TupleTag<?>, WindowedValue<?>> apply(Map.Entry<TupleTag<?>, WindowedValue<?>> input) {
                    return new Tuple2(input.getKey(), input.getValue());
                }
            });
        }
    }
}

