/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.spark.EvaluationResult;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.SparkContextFactory;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AggregatorRetrievalException;
import org.apache.beam.sdk.runners.AggregatorValues;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.api.java.JavaSparkContext;

public class EvaluationContext
implements EvaluationResult {
    private final JavaSparkContext jsc;
    private final Pipeline pipeline;
    private final SparkRuntimeContext runtime;
    private final Map<PValue, RDDHolder<?>> pcollections = new LinkedHashMap();
    private final Set<RDDHolder<?>> leafRdds = new LinkedHashSet();
    private final Set<PValue> multireads = new LinkedHashSet<PValue>();
    private final Map<PValue, Object> pobjects = new LinkedHashMap<PValue, Object>();
    private final Map<PValue, Iterable<? extends WindowedValue<?>>> pview = new LinkedHashMap();
    protected AppliedPTransform<?, ?, ?> currentTransform;

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline) {
        this.jsc = jsc;
        this.pipeline = pipeline;
        this.runtime = new SparkRuntimeContext(jsc, pipeline);
    }

    protected JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    protected Pipeline getPipeline() {
        return this.pipeline;
    }

    protected SparkRuntimeContext getRuntimeContext() {
        return this.runtime;
    }

    protected void setCurrentTransform(AppliedPTransform<?, ?, ?> transform) {
        this.currentTransform = transform;
    }

    protected AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    protected <T extends PInput> T getInput(PTransform<T, ?> transform) {
        Preconditions.checkArgument((this.currentTransform != null && this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
        PInput input = this.currentTransform.getInput();
        return (T)input;
    }

    protected <T extends POutput> T getOutput(PTransform<?, T> transform) {
        Preconditions.checkArgument((this.currentTransform != null && this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
        POutput output = this.currentTransform.getOutput();
        return (T)output;
    }

    protected <T> void setOutputRDD(PTransform<?, ?> transform, JavaRDDLike<WindowedValue<T>, ?> rdd) {
        this.setRDD((PValue)this.getOutput(transform), rdd);
    }

    protected <T> void setOutputRDDFromValues(PTransform<?, ?> transform, Iterable<T> values, Coder<T> coder) {
        this.pcollections.put((PValue)this.getOutput(transform), new RDDHolder<T>(values, coder));
    }

    void setPView(PValue view, Iterable<? extends WindowedValue<?>> value) {
        this.pview.put(view, value);
    }

    protected boolean hasOutputRDD(PTransform<? extends PInput, ?> transform) {
        PValue pvalue = (PValue)this.getOutput(transform);
        return this.pcollections.containsKey(pvalue);
    }

    protected JavaRDDLike<?, ?> getRDD(PValue pvalue) {
        RDDHolder<?> rddHolder = this.pcollections.get(pvalue);
        JavaRDDLike<WindowedValue<?>, ?> rdd = rddHolder.getRDD();
        this.leafRdds.remove(rddHolder);
        if (this.multireads.contains(pvalue)) {
            rdd.rdd().cache();
        } else {
            this.multireads.add(pvalue);
        }
        return rdd;
    }

    protected <T> void setRDD(PValue pvalue, JavaRDDLike<WindowedValue<T>, ?> rdd) {
        try {
            rdd.rdd().setName(pvalue.getName());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RDDHolder<T> rddHolder = new RDDHolder<T>(rdd);
        this.pcollections.put(pvalue, rddHolder);
        this.leafRdds.add(rddHolder);
    }

    JavaRDDLike<?, ?> getInputRDD(PTransform<? extends PInput, ?> transform) {
        return this.getRDD((PValue)this.getInput(transform));
    }

    <T> Iterable<? extends WindowedValue<?>> getPCollectionView(PCollectionView<T> view) {
        return this.pview.get(view);
    }

    public void computeOutputs() {
        for (RDDHolder<?> rddHolder : this.leafRdds) {
            JavaRDDLike<WindowedValue<?>, ?> rdd = rddHolder.getRDD();
            rdd.rdd().cache();
            rdd.count();
        }
    }

    @Override
    public <T> T get(PValue value) {
        if (this.pobjects.containsKey(value)) {
            Object result = this.pobjects.get(value);
            return (T)result;
        }
        if (this.pcollections.containsKey(value)) {
            JavaRDDLike<WindowedValue<?>, ?> rdd = this.pcollections.get(value).getRDD();
            Object res = Iterables.getOnlyElement((Iterable)rdd.collect());
            this.pobjects.put(value, res);
            return (T)res;
        }
        throw new IllegalStateException("Cannot resolve un-known PObject: " + value);
    }

    @Override
    public <T> T getAggregatorValue(String named, Class<T> resultType) {
        return this.runtime.getAggregatorValue(named, resultType);
    }

    public <T> AggregatorValues<T> getAggregatorValues(Aggregator<?, T> aggregator) throws AggregatorRetrievalException {
        return this.runtime.getAggregatorValues(aggregator);
    }

    @Override
    public <T> Iterable<T> get(PCollection<T> pcollection) {
        RDDHolder<?> rddHolder = this.pcollections.get(pcollection);
        Iterable<WindowedValue<?>> windowedValues = rddHolder.getValues(pcollection);
        return Iterables.transform(windowedValues, WindowingHelpers.unwindowValueFunction());
    }

    <T> Iterable<WindowedValue<T>> getWindowedValues(PCollection<T> pcollection) {
        RDDHolder<?> rddHolder = this.pcollections.get(pcollection);
        return rddHolder.getValues(pcollection);
    }

    @Override
    public void close() {
        SparkContextFactory.stopSparkContext(this.jsc);
    }

    public PipelineResult.State getState() {
        return PipelineResult.State.DONE;
    }

    private class RDDHolder<T> {
        private Iterable<WindowedValue<T>> windowedValues;
        private Coder<T> coder;
        private JavaRDDLike<WindowedValue<T>, ?> rdd;

        RDDHolder(Iterable<T> values, Coder<T> coder) {
            this.windowedValues = Iterables.transform(values, WindowingHelpers.windowValueFunction());
            this.coder = coder;
        }

        RDDHolder(JavaRDDLike<WindowedValue<T>, ?> rdd) {
            this.rdd = rdd;
        }

        JavaRDDLike<WindowedValue<T>, ?> getRDD() {
            if (this.rdd == null) {
                WindowedValue.ValueOnlyWindowedValueCoder windowCoder = WindowedValue.getValueOnlyCoder(this.coder);
                this.rdd = EvaluationContext.this.jsc.parallelize(CoderHelpers.toByteArrays(this.windowedValues, windowCoder)).map(CoderHelpers.fromByteFunction(windowCoder));
            }
            return this.rdd;
        }

        Iterable<WindowedValue<T>> getValues(PCollection<T> pcollection) {
            if (this.windowedValues == null) {
                WindowFn windowFn = pcollection.getWindowingStrategy().getWindowFn();
                Coder windowCoder = windowFn.windowCoder();
                Object windowedValueCoder = windowFn instanceof GlobalWindows ? WindowedValue.ValueOnlyWindowedValueCoder.of((Coder)pcollection.getCoder()) : WindowedValue.FullWindowedValueCoder.of((Coder)pcollection.getCoder(), (Coder)windowCoder);
                JavaRDD bytesRDD = this.rdd.map(CoderHelpers.toByteFunction(windowedValueCoder));
                List clientBytes = bytesRDD.collect();
                this.windowedValues = Iterables.transform((Iterable)clientBytes, (Function)new Function<byte[], WindowedValue<T>>((WindowedValue.WindowedValueCoder)windowedValueCoder){
                    final /* synthetic */ WindowedValue.WindowedValueCoder val$windowedValueCoder;
                    {
                        this.val$windowedValueCoder = windowedValueCoder;
                    }

                    public WindowedValue<T> apply(byte[] bytes) {
                        return (WindowedValue)CoderHelpers.fromByteArray(bytes, this.val$windowedValueCoder);
                    }
                });
            }
            return this.windowedValues;
        }
    }
}

