/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io.hadoop;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.spark.io.hadoop.ShardNameTemplateAware;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public final class HadoopIO {
    private HadoopIO() {
    }

    public static final class Write {
        private Write() {
        }

        public static <K, V> Bound<K, V> to(String filenamePrefix, Class<? extends FileOutputFormat<K, V>> format, Class<K> key, Class<V> value) {
            return new Bound<K, V>(filenamePrefix, format, key, value);
        }

        public static class Bound<K, V>
        extends PTransform<PCollection<KV<K, V>>, PDone> {
            private final String filenamePrefix;
            private final String filenameSuffix;
            private final int numShards;
            private final String shardTemplate;
            private final Class<? extends FileOutputFormat<K, V>> formatClass;
            private final Class<K> keyClass;
            private final Class<V> valueClass;
            private final Map<String, String> configurationProperties;

            Bound(String filenamePrefix, Class<? extends FileOutputFormat<K, V>> format, Class<K> key, Class<V> value) {
                this(filenamePrefix, "", 0, "-SSSSS-of-NNNNN", format, key, value, new HashMap<String, String>());
            }

            Bound(String filenamePrefix, String filenameSuffix, int numShards, String shardTemplate, Class<? extends FileOutputFormat<K, V>> format, Class<K> key, Class<V> value, Map<String, String> configurationProperties) {
                this.filenamePrefix = filenamePrefix;
                this.filenameSuffix = filenameSuffix;
                this.numShards = numShards;
                this.shardTemplate = shardTemplate;
                this.formatClass = format;
                this.keyClass = key;
                this.valueClass = value;
                this.configurationProperties = configurationProperties;
            }

            public Bound<K, V> withoutSharding() {
                return new Bound<K, V>(this.filenamePrefix, this.filenameSuffix, 1, "", this.formatClass, this.keyClass, this.valueClass, this.configurationProperties);
            }

            public Bound<K, V> withConfigurationProperty(String key, String value) {
                this.configurationProperties.put(key, value);
                return this;
            }

            public String getFilenamePrefix() {
                return this.filenamePrefix;
            }

            public String getShardTemplate() {
                return this.shardTemplate;
            }

            public int getNumShards() {
                return this.numShards;
            }

            public String getFilenameSuffix() {
                return this.filenameSuffix;
            }

            public Class<? extends FileOutputFormat<K, V>> getFormatClass() {
                return this.formatClass;
            }

            public Class<V> getValueClass() {
                return this.valueClass;
            }

            public Class<K> getKeyClass() {
                return this.keyClass;
            }

            public Map<String, String> getConfigurationProperties() {
                return this.configurationProperties;
            }

            public PDone apply(PCollection<KV<K, V>> input) {
                Preconditions.checkNotNull((Object)this.filenamePrefix, (Object)"need to set the filename prefix of an HadoopIO.Write transform");
                Preconditions.checkNotNull(this.formatClass, (Object)"need to set the format class of an HadoopIO.Write transform");
                Preconditions.checkNotNull(this.keyClass, (Object)"need to set the key class of an HadoopIO.Write transform");
                Preconditions.checkNotNull(this.valueClass, (Object)"need to set the value class of an HadoopIO.Write transform");
                Preconditions.checkArgument((boolean)ShardNameTemplateAware.class.isAssignableFrom(this.formatClass), (String)"Format class must implement %s", (Object[])new Object[]{ShardNameTemplateAware.class.getName()});
                return PDone.in((Pipeline)input.getPipeline());
            }
        }
    }

    public static final class Read {
        private Read() {
        }

        public static <K, V> Bound<K, V> from(String filepattern, Class<? extends FileInputFormat<K, V>> format, Class<K> key, Class<V> value) {
            return new Bound<K, V>(filepattern, format, key, value);
        }

        public static class Bound<K, V>
        extends PTransform<PInput, PCollection<KV<K, V>>> {
            private final String filepattern;
            private final Class<? extends FileInputFormat<K, V>> formatClass;
            private final Class<K> keyClass;
            private final Class<V> valueClass;

            Bound(String filepattern, Class<? extends FileInputFormat<K, V>> format, Class<K> key, Class<V> value) {
                Preconditions.checkNotNull((Object)filepattern, (Object)"need to set the filepattern of an HadoopIO.Read transform");
                Preconditions.checkNotNull(format, (Object)"need to set the format class of an HadoopIO.Read transform");
                Preconditions.checkNotNull(key, (Object)"need to set the key class of an HadoopIO.Read transform");
                Preconditions.checkNotNull(value, (Object)"need to set the value class of an HadoopIO.Read transform");
                this.filepattern = filepattern;
                this.formatClass = format;
                this.keyClass = key;
                this.valueClass = value;
            }

            public String getFilepattern() {
                return this.filepattern;
            }

            public Class<? extends FileInputFormat<K, V>> getFormatClass() {
                return this.formatClass;
            }

            public Class<V> getValueClass() {
                return this.valueClass;
            }

            public Class<K> getKeyClass() {
                return this.keyClass;
            }

            public PCollection<KV<K, V>> apply(PInput input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED);
            }
        }
    }
}

