/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import com.google.common.base.Preconditions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;

public final class CreateStream<T> {
    private CreateStream() {
    }

    public static <T> QueuedValues<T> fromQueue(Iterable<Iterable<T>> queuedValues) {
        return new QueuedValues<T>(queuedValues);
    }

    public static final class QueuedValues<T>
    extends PTransform<PInput, PCollection<T>> {
        private final Iterable<Iterable<T>> queuedValues;

        QueuedValues(Iterable<Iterable<T>> queuedValues) {
            Preconditions.checkNotNull(queuedValues, (Object)"need to set the queuedValues of an Create.QueuedValues transform");
            this.queuedValues = queuedValues;
        }

        public Iterable<Iterable<T>> getQueuedValues() {
            return this.queuedValues;
        }

        public PCollection<T> apply(PInput input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED);
        }
    }
}

