/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.coders;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public final class CoderHelpers {
    private CoderHelpers() {
    }

    public static <T> byte[] toByteArray(T value, Coder<T> coder) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            coder.encode(value, (OutputStream)baos, new Coder.Context(true));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
        return baos.toByteArray();
    }

    public static <T> List<byte[]> toByteArrays(Iterable<T> values, Coder<T> coder) {
        LinkedList<byte[]> res = new LinkedList<byte[]>();
        for (T value : values) {
            res.add(CoderHelpers.toByteArray(value, coder));
        }
        return res;
    }

    public static <T> T fromByteArray(byte[] serialized, Coder<T> coder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return (T)coder.decode((InputStream)bais, new Coder.Context(true));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }

    public static <T> org.apache.spark.api.java.function.Function<T, byte[]> toByteFunction(final Coder<T> coder) {
        return new org.apache.spark.api.java.function.Function<T, byte[]>(){

            public byte[] call(T t) throws Exception {
                return CoderHelpers.toByteArray(t, coder);
            }
        };
    }

    public static <T> org.apache.spark.api.java.function.Function<byte[], T> fromByteFunction(final Coder<T> coder) {
        return new org.apache.spark.api.java.function.Function<byte[], T>(){

            public T call(byte[] bytes) throws Exception {
                return CoderHelpers.fromByteArray(bytes, coder);
            }
        };
    }

    public static <K, V> PairFunction<Tuple2<K, V>, ByteArray, byte[]> toByteFunction(final Coder<K> keyCoder, final Coder<V> valueCoder) {
        return new PairFunction<Tuple2<K, V>, ByteArray, byte[]>(){

            public Tuple2<ByteArray, byte[]> call(Tuple2<K, V> kv) {
                return new Tuple2((Object)new ByteArray(CoderHelpers.toByteArray(kv._1(), keyCoder)), (Object)CoderHelpers.toByteArray(kv._2(), valueCoder));
            }
        };
    }

    public static <K, V> PairFunction<Tuple2<ByteArray, byte[]>, K, V> fromByteFunction(final Coder<K> keyCoder, final Coder<V> valueCoder) {
        return new PairFunction<Tuple2<ByteArray, byte[]>, K, V>(){

            public Tuple2<K, V> call(Tuple2<ByteArray, byte[]> tuple) {
                return new Tuple2(CoderHelpers.fromByteArray(((ByteArray)tuple._1()).getValue(), keyCoder), CoderHelpers.fromByteArray((byte[])tuple._2(), valueCoder));
            }
        };
    }

    public static <K, V> PairFunction<Tuple2<ByteArray, Iterable<byte[]>>, K, Iterable<V>> fromByteFunctionIterable(final Coder<K> keyCoder, final Coder<V> valueCoder) {
        return new PairFunction<Tuple2<ByteArray, Iterable<byte[]>>, K, Iterable<V>>(){

            public Tuple2<K, Iterable<V>> call(Tuple2<ByteArray, Iterable<byte[]>> tuple) {
                return new Tuple2(CoderHelpers.fromByteArray(((ByteArray)tuple._1()).getValue(), keyCoder), (Object)Iterables.transform((Iterable)((Iterable)tuple._2()), (Function)new Function<byte[], V>(){

                    public V apply(byte[] bytes) {
                        return CoderHelpers.fromByteArray(bytes, valueCoder);
                    }
                }));
            }
        };
    }
}

