/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import org.apache.beam.runners.spark.SparkPipelineRunner;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformTranslator;
import org.apache.beam.sdk.runners.TransformTreeNode;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Durations;

public final class StreamingWindowPipelineDetector
extends SparkPipelineRunner.Evaluator {
    private static final Duration SPARK_MIN_WINDOW = Durations.milliseconds((long)500L);
    private boolean windowing;
    private Duration batchDuration;
    private static final TransformTranslator.FieldGetter WINDOW_FG = new TransformTranslator.FieldGetter(Window.Bound.class);

    public StreamingWindowPipelineDetector(SparkPipelineTranslator translator) {
        super(translator);
    }

    @Override
    protected <TransformT extends PTransform<? super PInput, POutput>> void doVisitTransform(TransformTreeNode node) {
        PTransform transform = node.getTransform();
        Class<Window.Bound> transformClass = transform.getClass();
        if (transformClass.isAssignableFrom(Window.Bound.class)) {
            WindowFn windowFn = (WindowFn)WINDOW_FG.get("windowFn", transform);
            if (windowFn instanceof FixedWindows) {
                this.setBatchDuration(((FixedWindows)windowFn).getSize());
            } else if (windowFn instanceof SlidingWindows) {
                if (((SlidingWindows)windowFn).getOffset().getMillis() > 0L) {
                    throw new UnsupportedOperationException("Spark does not support window offsets");
                }
                this.setBatchDuration(((SlidingWindows)windowFn).getSize());
            } else if (!(windowFn instanceof GlobalWindows)) {
                String string = String.valueOf(windowFn);
                throw new IllegalStateException(new StringBuilder(34 + String.valueOf(string).length()).append("Windowing function not supported: ").append(string).toString());
            }
        }
    }

    private void setBatchDuration(org.joda.time.Duration duration) {
        Long durationMillis = duration.getMillis();
        if (durationMillis < SPARK_MIN_WINDOW.milliseconds()) {
            String string = String.valueOf(durationMillis);
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(string).length()).append("Windowing of size ").append(string).append("msec is not supported!").toString());
        }
        if (!this.windowing || this.batchDuration.milliseconds() > durationMillis) {
            this.batchDuration = Durations.milliseconds((long)durationMillis);
        }
        this.windowing = true;
    }

    public boolean isWindowing() {
        return this.windowing;
    }

    public Duration getBatchDuration() {
        return this.batchDuration;
    }
}

