/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.serializer.KryoSerializer;

public final class SparkContextFactory {
    static final String TEST_REUSE_SPARK_CONTEXT = "dataflow.spark.test.reuseSparkContext";
    private static JavaSparkContext sparkContext;
    private static String sparkMaster;

    private SparkContextFactory() {
    }

    public static synchronized JavaSparkContext getSparkContext(String master, String appName) {
        if (Boolean.getBoolean(TEST_REUSE_SPARK_CONTEXT)) {
            if (sparkContext == null) {
                sparkContext = SparkContextFactory.createSparkContext(master, appName);
                sparkMaster = master;
            } else if (!master.equals(sparkMaster)) {
                throw new IllegalArgumentException(String.format("Cannot reuse spark context with different spark master URL. Existing: %s, requested: %s.", sparkMaster, master));
            }
            return sparkContext;
        }
        return SparkContextFactory.createSparkContext(master, appName);
    }

    static synchronized void stopSparkContext(JavaSparkContext context) {
        if (!Boolean.getBoolean(TEST_REUSE_SPARK_CONTEXT)) {
            context.stop();
        }
    }

    private static JavaSparkContext createSparkContext(String master, String appName) {
        SparkConf conf = new SparkConf();
        conf.setMaster(master);
        conf.setAppName(appName);
        conf.set("spark.serializer", KryoSerializer.class.getCanonicalName());
        return new JavaSparkContext(conf);
    }
}

