/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io.hadoop;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;

public final class ShardNameBuilder {
    private ShardNameBuilder() {
    }

    public static String replaceShardCount(String template, int shardCount) {
        return ShardNameBuilder.replaceShardPattern(template, "N+", shardCount);
    }

    public static String replaceShardNumber(String template, int shardNumber) {
        return ShardNameBuilder.replaceShardPattern(template, "S+", shardNumber);
    }

    private static String replaceShardPattern(String template, String pattern, int n) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int n2 = m.group().length();
            m.appendReplacement(sb, new StringBuilder(17).append("%1\\$0").append(n2).append("d").toString());
        }
        m.appendTail(sb);
        return String.format(sb.toString(), n);
    }

    public static String getOutputDirectory(String pathPrefix, String template) {
        String string = String.valueOf(pathPrefix);
        String string2 = String.valueOf(template);
        String out = new Path(string2.length() != 0 ? string.concat(string2) : new String(string)).getParent().toString();
        if (out.isEmpty()) {
            return "./";
        }
        return out;
    }

    public static String getOutputFilePrefix(String pathPrefix, String template) {
        String string = String.valueOf(pathPrefix);
        String string2 = String.valueOf(template);
        String name = new Path(string2.length() != 0 ? string.concat(string2) : new String(string)).getName();
        if (name.endsWith(template)) {
            return name.substring(0, name.length() - template.length());
        }
        return "";
    }

    public static String getOutputFileTemplate(String pathPrefix, String template) {
        String string = String.valueOf(pathPrefix);
        String string2 = String.valueOf(template);
        String name = new Path(string2.length() != 0 ? string.concat(string2) : new String(string)).getName();
        if (name.endsWith(template)) {
            return template;
        }
        return name;
    }
}

