/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import kafka.serializer.Decoder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;

public final class KafkaIO {
    private KafkaIO() {
    }

    public static final class Read {
        private Read() {
        }

        public static <K, V> Unbound<K, V> from(Class<? extends Decoder<K>> keyDecoder, Class<? extends Decoder<V>> valueDecoder, Class<K> key, Class<V> value, Set<String> topics, Map<String, String> kafkaParams) {
            return new Unbound<K, V>(keyDecoder, valueDecoder, key, value, topics, kafkaParams);
        }

        public static class Unbound<K, V>
        extends PTransform<PInput, PCollection<KV<K, V>>> {
            private final Class<? extends Decoder<K>> keyDecoderClass;
            private final Class<? extends Decoder<V>> valueDecoderClass;
            private final Class<K> keyClass;
            private final Class<V> valueClass;
            private final Set<String> topics;
            private final Map<String, String> kafkaParams;

            Unbound(Class<? extends Decoder<K>> keyDecoder, Class<? extends Decoder<V>> valueDecoder, Class<K> key, Class<V> value, Set<String> topics, Map<String, String> kafkaParams) {
                Preconditions.checkNotNull(keyDecoder, (Object)"need to set the key decoder class of a KafkaIO.Read transform");
                Preconditions.checkNotNull(valueDecoder, (Object)"need to set the value decoder class of a KafkaIO.Read transform");
                Preconditions.checkNotNull(key, (Object)"need to set the key class of aKafkaIO.Read transform");
                Preconditions.checkNotNull(value, (Object)"need to set the value class of a KafkaIO.Read transform");
                Preconditions.checkNotNull(topics, (Object)"need to set the topics of a KafkaIO.Read transform");
                Preconditions.checkNotNull(kafkaParams, (Object)"need to set the kafkaParams of a KafkaIO.Read transform");
                this.keyDecoderClass = keyDecoder;
                this.valueDecoderClass = valueDecoder;
                this.keyClass = key;
                this.valueClass = value;
                this.topics = topics;
                this.kafkaParams = kafkaParams;
            }

            public Class<? extends Decoder<K>> getKeyDecoderClass() {
                return this.keyDecoderClass;
            }

            public Class<? extends Decoder<V>> getValueDecoderClass() {
                return this.valueDecoderClass;
            }

            public Class<V> getValueClass() {
                return this.valueClass;
            }

            public Class<K> getKeyClass() {
                return this.keyClass;
            }

            public Set<String> getTopics() {
                return this.topics;
            }

            public Map<String, String> getKafkaParams() {
                return this.kafkaParams;
            }

            public PCollection<KV<K, V>> apply(PInput input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED);
            }
        }
    }
}

