/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.repackaged.beam_runners_samza.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_samza.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_samza.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.util.Base64Serializer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.config.factories.PropertiesConfigFactory;
import org.apache.samza.container.grouper.task.SingleContainerGrouperFactory;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.apache.samza.serializers.ByteSerdeFactory;
import org.apache.samza.standalone.PassthroughCoordinationUtilsFactory;
import org.apache.samza.standalone.PassthroughJobCoordinatorFactory;

public class ConfigBuilder {
    private static final String APP_RUNNER_CLASS = "app.runner.class";
    private final Map<String, String> config = new HashMap<String, String>();
    private final SamzaPipelineOptions options;

    public ConfigBuilder(SamzaPipelineOptions options) {
        this.options = options;
    }

    public void put(String name, String property) {
        this.config.put(name, property);
    }

    public void putAll(Map<String, String> properties) {
        this.config.putAll(properties);
    }

    public Config build() {
        try {
            this.config.putAll(ConfigBuilder.systemStoreConfig());
            this.config.putAll(ConfigBuilder.createUserConfig(this.options));
            this.config.put(JobConfig.JOB_NAME(), this.options.getJobName());
            this.config.put("beamPipelineOptions", Base64Serializer.serializeUnchecked((Serializable)new SerializablePipelineOptions((PipelineOptions)this.options)));
            this.config.put("app.run.id", String.valueOf(System.currentTimeMillis()) + "-" + UUID.randomUUID().toString().substring(0, 8));
            return new MapConfig(this.config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> createUserConfig(SamzaPipelineOptions options) {
        String configFilePath = options.getConfigFilePath();
        HashMap<String, String> config = new HashMap<String, String>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configFilePath})) {
            File configFile = new File(configFilePath);
            Preconditions.checkArgument(configFile.exists(), "Config file %s does not exist", (Object)configFilePath);
            PropertiesConfigFactory configFactory = new PropertiesConfigFactory();
            URI configUri = configFile.toURI();
            config.putAll((Map<String, String>)configFactory.getConfig(configUri));
        }
        if (options.getConfigOverride() != null) {
            config.putAll(options.getConfigOverride());
        }
        if (config.isEmpty()) {
            config.putAll(ConfigBuilder.localRunConfig());
        }
        return config;
    }

    @VisibleForTesting
    public static Map<String, String> localRunConfig() {
        return ImmutableMap.builder().put(APP_RUNNER_CLASS, LocalApplicationRunner.class.getName()).put("job.coordinator.factory", PassthroughJobCoordinatorFactory.class.getName()).put("job.coordination.utils.factory", PassthroughCoordinationUtilsFactory.class.getName()).put(TaskConfig.GROUPER_FACTORY(), SingleContainerGrouperFactory.class.getName()).put(TaskConfig.COMMIT_MS(), "-1").put("processor.id", "1").build();
    }

    private static Map<String, String> systemStoreConfig() {
        return ImmutableMap.builder().put("stores.beamStore.factory", "org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory").put("stores.beamStore.key.serde", "byteSerde").put("stores.beamStore.msg.serde", "byteSerde").put("serializers.registry.byteSerde.class", ByteSerdeFactory.class.getName()).build();
    }
}

