/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.container;

import java.net.URI;
import java.util.Random;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigFactory;
import org.apache.samza.config.ShellCommandConfig;
import org.apache.samza.container.SamzaContainer;
import org.apache.samza.job.model.JobModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerCfgFactory
implements ConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCfgFactory.class);
    private static final Object LOCK = new Object();
    static volatile JobModel jobModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config getConfig(URI configUri) {
        if (jobModel == null) {
            Object object = LOCK;
            synchronized (object) {
                if (jobModel == null) {
                    String containerId = System.getenv(ShellCommandConfig.ENV_CONTAINER_ID());
                    LOG.info(String.format("Got container ID: %s", containerId));
                    String coordinatorUrl = System.getenv(ShellCommandConfig.ENV_COORDINATOR_URL());
                    LOG.info(String.format("Got coordinator URL: %s", coordinatorUrl));
                    int delay = new Random().nextInt(SamzaContainer.DEFAULT_READ_JOBMODEL_DELAY_MS()) + 1;
                    jobModel = SamzaContainer.readJobModel((String)coordinatorUrl, (int)delay);
                }
            }
        }
        return jobModel.getConfig();
    }
}

