/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.Serializable;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.TimerKey;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.samza.config.Config;
import org.apache.samza.operators.TimerRegistry;
import org.apache.samza.task.TaskContext;
import org.joda.time.Instant;

public interface Op<InT, OutT, K>
extends Serializable {
    default public void open(Config config, TaskContext taskContext, TimerRegistry<TimerKey<K>> timerRegistry, OpEmitter<OutT> emitter) {
    }

    public void processElement(WindowedValue<InT> var1, OpEmitter<OutT> var2);

    default public void processWatermark(Instant watermark, OpEmitter<OutT> emitter) {
        emitter.emitWatermark(watermark);
    }

    default public void processSideInput(String id, WindowedValue<? extends Iterable<?>> elements, OpEmitter<OutT> emitter) {
        throw new UnsupportedOperationException("Side inputs not supported for: " + this.getClass());
    }

    default public void processSideInputWatermark(Instant watermark, OpEmitter<OutT> emitter) {
    }

    default public void processTimer(KeyedTimerData<K> keyedTimerData) {
    }

    default public void close() {
    }
}

