/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Arrays;
import org.apache.beam.runners.core.TimerInternals;

public class KeyedTimerData<K>
implements Comparable<KeyedTimerData<K>> {
    private final byte[] keyBytes;
    private final K key;
    private final TimerInternals.TimerData timerData;

    public KeyedTimerData(byte[] keyBytes, K key, TimerInternals.TimerData timerData) {
        this.keyBytes = keyBytes;
        this.key = key;
        this.timerData = timerData;
    }

    public K getKey() {
        return this.key;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public TimerInternals.TimerData getTimerData() {
        return this.timerData;
    }

    @Override
    public int compareTo(KeyedTimerData<K> other) {
        int timerCompare = this.getTimerData().compareTo(other.getTimerData());
        if (timerCompare != 0) {
            return timerCompare;
        }
        if (this.keyBytes == null) {
            return other.keyBytes == null ? 0 : -1;
        }
        if (other.keyBytes == null) {
            return 1;
        }
        if (this.keyBytes.length < other.keyBytes.length) {
            return -1;
        }
        if (this.keyBytes.length > other.keyBytes.length) {
            return 1;
        }
        for (int i = 0; i < this.keyBytes.length; ++i) {
            char b1 = (char)this.keyBytes[i];
            char b2 = (char)other.keyBytes[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyedTimerData that = (KeyedTimerData)o;
        return Arrays.equals(this.keyBytes, that.keyBytes) && this.timerData.equals(that.timerData);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keyBytes);
        result = 31 * result + this.timerData.hashCode();
        return result;
    }
}

