/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Collection;
import java.util.Collections;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.GroupAlsoByWindowViaWindowSetNewDoFn;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItemCoder;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.NullSideInputReader;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.samza.SamzaExecutionContext;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.metrics.DoFnRunnerWithMetrics;
import org.apache.beam.runners.samza.runtime.DoFnRunnerWithKeyedInternals;
import org.apache.beam.runners.samza.runtime.KeyedInternals;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.runners.samza.runtime.Op;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.OutputManagerFactory;
import org.apache.beam.runners.samza.runtime.SamzaStoreStateInternals;
import org.apache.beam.runners.samza.runtime.SamzaTimerInternalsFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.operators.Scheduler;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByKeyOp<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements Op<KeyedWorkItem<K, InputT>, KV<K, OutputT>, K> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GroupByKeyOp.class);
    private static final @UnknownKeyFor @NonNull @Initialized String TIMER_STATE_ID = "timer";
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> mainOutputTag;
    private final @UnknownKeyFor @NonNull @Initialized KeyedWorkItemCoder<K, InputT> inputCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized OutputManagerFactory<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputManagerFactory;
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SystemReduceFn<K, InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT, @UnknownKeyFor @NonNull @Initialized BoundedWindow> reduceFn;
    private final @UnknownKeyFor @NonNull @Initialized String transformFullName;
    private final @UnknownKeyFor @NonNull @Initialized String transformId;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded;
    private transient @UnknownKeyFor @NonNull @Initialized StateInternalsFactory<K> stateInternalsFactory;
    private transient @UnknownKeyFor @NonNull @Initialized SamzaTimerInternalsFactory<K> timerInternalsFactory;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> fnRunner;
    private transient @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions;

    public GroupByKeyOp(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> mainOutputTag, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SystemReduceFn<K, InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT, @UnknownKeyFor @NonNull @Initialized BoundedWindow> reduceFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowingStrategy, @UnknownKeyFor @NonNull @Initialized OutputManagerFactory<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputManagerFactory, @UnknownKeyFor @NonNull @Initialized String transformFullName, @UnknownKeyFor @NonNull @Initialized String transformId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded) {
        this.mainOutputTag = mainOutputTag;
        this.windowingStrategy = windowingStrategy;
        this.outputManagerFactory = outputManagerFactory;
        this.transformFullName = transformFullName;
        this.transformId = transformId;
        this.isBounded = isBounded;
        if (!(inputCoder instanceof KeyedWorkItemCoder)) {
            throw new IllegalArgumentException(String.format("GroupByKeyOp requires input to use KeyedWorkItemCoder. Got: %s", inputCoder.getClass()));
        }
        this.inputCoder = (KeyedWorkItemCoder)inputCoder;
        this.keyCoder = this.inputCoder.getKeyCoder();
        this.reduceFn = reduceFn;
    }

    @Override
    public void open(@UnknownKeyFor @NonNull @Initialized Config config, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Scheduler<@UnknownKeyFor @NonNull @Initialized KeyedTimerData<K>> timerRegistry, @UnknownKeyFor @NonNull @Initialized OpEmitter<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> emitter) {
        SamzaExecutionContext samzaExecutionContext = (SamzaExecutionContext)context.getApplicationContainerContext();
        this.pipelineOptions = samzaExecutionContext.getPipelineOptions();
        SamzaStoreStateInternals.Factory nonKeyedStateInternalsFactory = SamzaStoreStateInternals.createNonKeyedStateInternalsFactory(this.transformId, context.getTaskContext(), this.pipelineOptions);
        DoFnRunners.OutputManager outputManager = this.outputManagerFactory.create(emitter);
        this.stateInternalsFactory = new SamzaStoreStateInternals.Factory<K>(this.transformId, Collections.singletonMap("beamStore", SamzaStoreStateInternals.getBeamStore(context.getTaskContext())), this.keyCoder, this.pipelineOptions.getStoreBatchGetSize());
        this.timerInternalsFactory = SamzaTimerInternalsFactory.createTimerInternalFactory(this.keyCoder, timerRegistry, TIMER_STATE_ID, nonKeyedStateInternalsFactory, this.windowingStrategy, this.isBounded, this.pipelineOptions);
        DoFn doFn = GroupAlsoByWindowViaWindowSetNewDoFn.create(this.windowingStrategy, this.stateInternalsFactory, this.timerInternalsFactory, (SideInputReader)NullSideInputReader.of(Collections.emptyList()), this.reduceFn, (DoFnRunners.OutputManager)outputManager, this.mainOutputTag);
        final KeyedInternals<K> keyedInternals = new KeyedInternals<K>(this.stateInternalsFactory, this.timerInternalsFactory);
        StepContext stepContext = new StepContext(){

            public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
                return keyedInternals.stateInternals();
            }

            public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
                return keyedInternals.timerInternals();
            }
        };
        DoFnRunner doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)PipelineOptionsFactory.create(), (DoFn)doFn, (SideInputReader)NullSideInputReader.of(Collections.emptyList()), (DoFnRunners.OutputManager)outputManager, this.mainOutputTag, Collections.emptyList(), (StepContext)stepContext, null, Collections.emptyMap(), this.windowingStrategy, (DoFnSchemaInformation)DoFnSchemaInformation.create(), Collections.emptyMap());
        DoFnRunner dropLateDataRunner = this.pipelineOptions.getDropLateData() ? DoFnRunners.lateDataDroppingRunner((DoFnRunner)doFnRunner, (TimerInternals)keyedInternals.timerInternals(), this.windowingStrategy) : doFnRunner;
        SamzaExecutionContext executionContext = (SamzaExecutionContext)context.getApplicationContainerContext();
        DoFnRunner doFnRunnerWithMetrics = DoFnRunnerWithMetrics.wrap(dropLateDataRunner, executionContext.getMetricsContainer(), this.transformFullName);
        this.fnRunner = new DoFnRunnerWithKeyedInternals(doFnRunnerWithMetrics, keyedInternals);
    }

    @Override
    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>> inputElement, @UnknownKeyFor @NonNull @Initialized OpEmitter<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> emitter) {
        this.fnRunner.startBundle();
        this.fnRunner.processElement(inputElement);
        this.fnRunner.finishBundle();
    }

    @Override
    public void processWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark, @UnknownKeyFor @NonNull @Initialized OpEmitter<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> emitter) {
        this.timerInternalsFactory.setInputWatermark(watermark);
        Collection<KeyedTimerData<K>> readyTimers = this.timerInternalsFactory.removeReadyTimers();
        if (!readyTimers.isEmpty()) {
            this.fnRunner.startBundle();
            for (KeyedTimerData<K> keyedTimerData : readyTimers) {
                this.fireTimer(keyedTimerData.getKey(), keyedTimerData.getTimerData());
            }
            this.fnRunner.finishBundle();
        }
        if (this.timerInternalsFactory.getOutputWatermark() == null || this.timerInternalsFactory.getOutputWatermark().isBefore((ReadableInstant)watermark)) {
            this.timerInternalsFactory.setOutputWatermark(watermark);
            emitter.emitWatermark(this.timerInternalsFactory.getOutputWatermark());
        }
    }

    @Override
    public void processTimer(@UnknownKeyFor @NonNull @Initialized KeyedTimerData<K> keyedTimerData, @UnknownKeyFor @NonNull @Initialized OpEmitter<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> emitter) {
        this.fnRunner.startBundle();
        this.fireTimer(keyedTimerData.getKey(), keyedTimerData.getTimerData());
        this.fnRunner.finishBundle();
        this.timerInternalsFactory.removeProcessingTimer(keyedTimerData);
    }

    private void fireTimer(K key, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
        LOG.debug("Firing timer {} for key {}", (Object)timer, key);
        this.fnRunner.processElement(WindowedValue.valueInGlobalWindow((Object)KeyedWorkItems.timersWorkItem(key, Collections.singletonList(timer))));
    }
}

