/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class Base64Serializer {
    private Base64Serializer() {
    }

    public static String serializeUnchecked(Serializable serializable) {
        try {
            return Base64Serializer.serialize(serializable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserializeUnchecked(String serialized, Class<T> klass) {
        try {
            return Base64Serializer.deserialize(serialized, klass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(String serialized, Class<T> klass) throws IOException, ClassNotFoundException {
        byte[] bytes = Base64.getDecoder().decode(serialized);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object object = ois.readObject();
        ois.close();
        return (T)object;
    }

    private static String serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(serializable);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

