/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.runners.samza.runtime.FutureCollector;
import org.apache.beam.runners.samza.util.FutureUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class FutureCollectorImpl<@UnknownKeyFor OutT>
implements FutureCollector<OutT> {
    private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean collectorSealed;
    private @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>>> outputFuture = CompletableFuture.completedFuture(new ArrayList());

    FutureCollectorImpl() {
        this.collectorSealed = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>> element) {
        Preconditions.checkState((!this.collectorSealed.get() ? 1 : 0) != 0, (Object)"Cannot add element to an unprepared collector. Make sure prepare() is invoked before adding elements.");
        FutureCollectorImpl futureCollectorImpl = this;
        synchronized (futureCollectorImpl) {
            this.outputFuture = this.outputFuture.thenCombine(element, (collection, event) -> {
                collection.add(event);
                return collection;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(@UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>>> elements) {
        Preconditions.checkState((!this.collectorSealed.get() ? 1 : 0) != 0, (Object)"Cannot add elements to an unprepared collector. Make sure prepare() is invoked before adding elements.");
        FutureCollectorImpl futureCollectorImpl = this;
        synchronized (futureCollectorImpl) {
            this.outputFuture = FutureUtils.combineFutures(this.outputFuture, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard() {
        this.collectorSealed.compareAndSet(false, true);
        FutureCollectorImpl futureCollectorImpl = this;
        synchronized (futureCollectorImpl) {
            this.outputFuture = CompletableFuture.completedFuture(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>>> finish() {
        this.collectorSealed.compareAndSet(false, true);
        FutureCollectorImpl futureCollectorImpl = this;
        synchronized (futureCollectorImpl) {
            CompletionStage<Collection<WindowedValue<OutT>>> sealedOutputFuture = this.outputFuture;
            this.outputFuture = CompletableFuture.completedFuture(new ArrayList());
            return sealedOutputFuture;
        }
    }

    @Override
    public void prepare() {
        boolean isCollectorSealed = this.collectorSealed.compareAndSet(true, false);
        Preconditions.checkState((boolean)isCollectorSealed, (Object)"Failed to prepare the collector. Collector needs to be sealed before prepare() is invoked.");
    }
}

