/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Collection;
import org.apache.beam.runners.samza.runtime.Op;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.SamzaAssignContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class WindowAssignOp<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements Op<T, T, Void> {
    private final @UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn;

    public WindowAssignOp(@UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn) {
        this.windowFn = windowFn;
    }

    @Override
    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> inputElement, @UnknownKeyFor @NonNull @Initialized OpEmitter<T> emitter) {
        Collection windows;
        try {
            windows = this.windowFn.assignWindows(new SamzaAssignContext<T, W>(this.windowFn, inputElement));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        windows.stream().map(window -> WindowedValue.of((Object)inputElement.getValue(), (Instant)inputElement.getTimestamp(), (BoundedWindow)window, (PaneInfo)inputElement.getPane())).forEach(outputElement -> emitter.emitElement((WindowedValue)outputElement));
    }
}

