/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Map;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamzaMetricsBundleProgressHandler
implements BundleProgressHandler {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaMetricsBundleProgressHandler.class);
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer samzaMetricsContainer;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> transformIdToUniqueName;

    public SamzaMetricsBundleProgressHandler(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer samzaMetricsContainer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> transformIdToUniqueName) {
        this.stepName = stepName;
        this.samzaMetricsContainer = samzaMetricsContainer;
        this.transformIdToUniqueName = transformIdToUniqueName;
    }

    public void onProgress(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleProgressResponse progress) {
    }

    public void onCompleted(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleResponse response) {
        response.getMonitoringInfosList().stream().filter(monitoringInfo -> !monitoringInfo.getPayload().isEmpty()).map(this::parseAndUpdateMetric).distinct().forEach(this.samzaMetricsContainer::updateMetrics);
    }

    private @UnknownKeyFor @NonNull @Initialized String parseAndUpdateMetric(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        String pTransformId = monitoringInfo.getLabelsOrDefault("PTRANSFORM", this.stepName);
        String transformUniqueName = this.transformIdToUniqueName.getOrDefault(pTransformId, pTransformId);
        String className = monitoringInfo.getLabelsOrDefault("NAMESPACE", monitoringInfo.getUrn());
        String userMetricName = monitoringInfo.getLabelsOrDefault("NAME", monitoringInfo.getLabelsMap().toString());
        MetricsContainer metricsContainer = this.samzaMetricsContainer.getContainer(transformUniqueName);
        MetricName metricName = MetricName.named((String)className, (String)userMetricName);
        switch (monitoringInfo.getType()) {
            case "beam:metrics:sum_int64:v1": {
                Counter counter = metricsContainer.getCounter(metricName);
                counter.inc(MonitoringInfoEncodings.decodeInt64Counter((ByteString)monitoringInfo.getPayload()));
                break;
            }
            case "beam:metrics:distribution_int64:v1": {
                Distribution distribution = metricsContainer.getDistribution(metricName);
                DistributionData data = MonitoringInfoEncodings.decodeInt64Distribution((ByteString)monitoringInfo.getPayload());
                distribution.update(data.sum(), data.count(), data.min(), data.max());
                break;
            }
            case "beam:metrics:latest_int64:v1": {
                Gauge gauge = metricsContainer.getGauge(metricName);
                gauge.set(MonitoringInfoEncodings.decodeInt64Gauge((ByteString)monitoringInfo.getPayload()).value());
                break;
            }
            default: {
                LOG.debug("Unsupported metric type {}", (Object)monitoringInfo.getType());
            }
        }
        return transformUniqueName;
    }
}

