/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.runners.samza.translation.ConfigContext;
import org.apache.beam.runners.samza.translation.SamzaPipelineTranslator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.gson.JsonArray;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.gson.JsonObject;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.gson.JsonParser;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.samza.config.Config;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineJsonRenderer
implements Pipeline.PipelineVisitor {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PipelineJsonRenderer.class);
    private static final @UnknownKeyFor @NonNull @Initialized String TRANSFORM_IO_MAP_DELIMITER = ",";
    private static final @UnknownKeyFor @NonNull @Initialized String OUTERMOST_NODE = "OuterMostNode";
    @Nullable
    private static final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SamzaIOInfo SAMZA_IO_INFO = PipelineJsonRenderer.loadSamzaIOInfo();
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder jsonBuilder = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder graphLinks = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder transformIoInfo = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> valueToProducerNodeName = new HashMap<PValue, String>();
    private final @UnknownKeyFor @NonNull @Initialized ConfigContext ctx;
    private @UnknownKeyFor @NonNull @Initialized int indent;

    public static @UnknownKeyFor @NonNull @Initialized String toJsonString(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized ConfigContext ctx) {
        PipelineJsonRenderer visitor = new PipelineJsonRenderer(ctx);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.jsonBuilder.toString();
    }

    @DoNotCall(value="JSON DAG for portable pipeline is not supported yet.")
    public static @UnknownKeyFor @NonNull @Initialized String toJsonString(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        throw new UnsupportedOperationException("JSON DAG for portable pipeline is not supported yet.");
    }

    private PipelineJsonRenderer(@UnknownKeyFor @NonNull @Initialized ConfigContext ctx) {
        this.ctx = ctx;
    }

    @Nullable
    private static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SamzaIOInfo loadSamzaIOInfo() {
        Iterator<SamzaIORegistrar> beamIORegistrarIterator = ServiceLoader.load(SamzaIORegistrar.class).iterator();
        return beamIORegistrarIterator.hasNext() ? ((SamzaIORegistrar)Iterators.getOnlyElement(beamIORegistrarIterator)).getSamzaIO() : null;
    }

    public void enterPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        this.writeLine("{ \n \"RootNode\": [", new Object[0]);
        this.graphLinks.append(",\"graphLinks\": [");
        Map<String, Map.Entry<String, String>> transformIOMap = PipelineJsonRenderer.buildTransformIOMap(p, this.ctx);
        this.buildTransformIoJson(transformIOMap);
        this.enterBlock();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        Optional<String> ioInfo;
        String fullName = node.getFullName();
        this.writeLine("{ \"fullName\":\"%s\",", this.assignNodeName(fullName));
        if (node.getEnclosingNode() != null) {
            String enclosingNodeName = node.getEnclosingNode().getFullName();
            this.writeLine("  \"enclosingNode\":\"%s\",", this.assignNodeName(enclosingNodeName));
        }
        if ((ioInfo = this.getIOInfo(node)).isPresent() && !ioInfo.get().isEmpty()) {
            this.writeLine(" \"ioInfo\":\"%s\",", PipelineJsonRenderer.escapeString(ioInfo.get()));
        }
        this.writeLine("  \"ChildNodes\":[", new Object[0]);
        this.enterBlock();
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        this.exitBlock();
        this.writeLine("]},", new Object[0]);
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        String fullName = node.getFullName();
        this.writeLine("{ \"fullName\":\"%s\",", PipelineJsonRenderer.escapeString(fullName));
        String enclosingNodeName = node.getEnclosingNode().getFullName();
        this.writeLine("  \"enclosingNode\":\"%s\"},", this.assignNodeName(enclosingNodeName));
        node.getOutputs().values().forEach(x -> this.valueToProducerNodeName.put((PValue)x, fullName));
        node.getInputs().forEach((key, value) -> {
            String producerName = this.valueToProducerNodeName.get(value);
            this.graphLinks.append(String.format("{\"from\":\"%s\",\"to\":\"%s\"},", producerName, fullName));
        });
    }

    public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
    }

    public void leavePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this.exitBlock();
        this.writeLine("]", new Object[0]);
        int lastIndex = this.graphLinks.length() - 1;
        if (this.graphLinks.charAt(lastIndex) == ',') {
            this.graphLinks.deleteCharAt(lastIndex);
        }
        this.graphLinks.append("]");
        this.jsonBuilder.append((CharSequence)this.graphLinks);
        this.jsonBuilder.append((CharSequence)this.transformIoInfo);
        this.jsonBuilder.append("}");
    }

    private void buildTransformIoJson(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> transformIOMap) {
        this.transformIoInfo.append(",\"transformIOInfo\": [");
        transformIOMap.forEach((transform, ioInfo) -> this.transformIoInfo.append(String.format("{\"transformName\":\"%s\",\"inputs\":\"%s\",\"outputs\":\"%s\"},", transform, ioInfo.getKey(), ioInfo.getValue())));
        int lastIndex = this.transformIoInfo.length() - 1;
        if (this.transformIoInfo.charAt(lastIndex) == ',') {
            this.transformIoInfo.deleteCharAt(lastIndex);
        }
        this.transformIoInfo.append("]");
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    @FormatMethod
    private void writeLine(@FormatString @UnknownKeyFor @NonNull @Initialized String format, Object ... args) {
        int secondLastCharIndex = this.jsonBuilder.length() - 2;
        if (this.jsonBuilder.length() > 1 && this.jsonBuilder.charAt(secondLastCharIndex) == ',' && (format.startsWith("}") || format.startsWith("]"))) {
            this.jsonBuilder.deleteCharAt(secondLastCharIndex);
        }
        if (this.indent != 0) {
            this.jsonBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.jsonBuilder.append(String.format(format, args));
        this.jsonBuilder.append("\n");
    }

    private static @UnknownKeyFor @NonNull @Initialized String escapeString(@UnknownKeyFor @NonNull @Initialized String x) {
        return x.replace("\"", "\\\"");
    }

    private @UnknownKeyFor @NonNull @Initialized String assignNodeName(@UnknownKeyFor @NonNull @Initialized String nodeName) {
        return PipelineJsonRenderer.escapeString(nodeName.isEmpty() ? OUTERMOST_NODE : nodeName);
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getIOInfo(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        if (SAMZA_IO_INFO == null) {
            return Optional.empty();
        }
        return SAMZA_IO_INFO.getIOInfo(node);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> buildTransformIOMap(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, final @UnknownKeyFor @NonNull @Initialized ConfigContext ctx) {
        final HashMap<String, Map.Entry<String, String>> pTransformToInputOutputMap = new HashMap<String, Map.Entry<String, String>>();
        SamzaPipelineTranslator.TransformVisitorFn configFn = new SamzaPipelineTranslator.TransformVisitorFn(){

            @Override
            public <T extends PTransform<?, ?>> void apply(T transform, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TransformTranslator<T> translator) {
                ctx.setCurrentTransform(node.toAppliedPTransform(pipeline));
                List inputs = (List)PipelineJsonRenderer.getIOPValueList(node.getInputs()).get();
                List outputs = (List)PipelineJsonRenderer.getIOPValueList(node.getOutputs()).get();
                pTransformToInputOutputMap.put(node.getFullName(), new AbstractMap.SimpleEntry<String, String>(String.join((CharSequence)PipelineJsonRenderer.TRANSFORM_IO_MAP_DELIMITER, inputs), String.join((CharSequence)PipelineJsonRenderer.TRANSFORM_IO_MAP_DELIMITER, outputs)));
                ctx.clearCurrentTransform();
            }
        };
        SamzaPipelineTranslator.SamzaPipelineVisitor visitor = new SamzaPipelineTranslator.SamzaPipelineVisitor(configFn);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return pTransformToInputOutputMap;
    }

    private static @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> getIOPValueList(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> map) {
        return () -> map.values().stream().map(pColl -> pColl.getName()).collect(Collectors.toList());
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>>> getTransformIOMap(@UnknownKeyFor @NonNull @Initialized Config config) {
        Preconditions.checkNotNull((Object)config, (Object)"Config cannot be null");
        HashMap<String, Map.Entry<List<String>, List<String>>> result = new HashMap<String, Map.Entry<List<String>, List<String>>>();
        String pipelineJsonGraph = (String)config.get((Object)"beamJsonGraph");
        if (pipelineJsonGraph == null) {
            LOG.warn("Cannot build transformIOMap since Config: {} is found null ", (Object)"beamJsonGraph");
            return result;
        }
        JsonObject jsonObject = JsonParser.parseString((String)pipelineJsonGraph).getAsJsonObject();
        JsonArray transformIOInfo = jsonObject.getAsJsonArray("transformIOInfo");
        transformIOInfo.forEach(transform -> {
            String transformName = transform.getAsJsonObject().get("transformName").getAsString();
            String inputs = transform.getAsJsonObject().get("inputs").getAsString();
            String outputs = transform.getAsJsonObject().get("outputs").getAsString();
            result.put(transformName, new AbstractMap.SimpleEntry<List<String>, List<String>>(PipelineJsonRenderer.ioFunc(inputs), PipelineJsonRenderer.ioFunc(outputs)));
        });
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ioFunc(@UnknownKeyFor @NonNull @Initialized String ioList) {
        return Arrays.stream(ioList.split(TRANSFORM_IO_MAP_DELIMITER)).filter(item -> !item.isEmpty()).collect(Collectors.toList());
    }

    public static interface SamzaIORegistrar {
        public @UnknownKeyFor @NonNull @Initialized SamzaIOInfo getSamzaIO();
    }

    public static interface SamzaIOInfo {
        public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getIOInfo(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1);
    }
}

