/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.adapter.BoundedSourceSystem;
import org.apache.beam.runners.samza.adapter.UnboundedSourceSystem;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.util.SamzaCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.GenericInputDescriptor;
import org.apache.samza.system.descriptors.GenericSystemDescriptor;

public class ReadTranslator<T>
implements TransformTranslator<PTransform<PBegin, PCollection<T>>> {
    @Override
    public void translate(PTransform<PBegin, PCollection<T>> transform, TransformHierarchy.Node node, TranslationContext ctx) {
        PCollection<T> output = ctx.getOutput(transform);
        Coder<WindowedValue<T>> coder = SamzaCoders.of(output);
        BoundedSource source = transform instanceof SplittableParDo.PrimitiveBoundedRead ? ((SplittableParDo.PrimitiveBoundedRead)transform).getSource() : ((SplittableParDo.PrimitiveUnboundedRead)transform).getSource();
        String id = ctx.getIdForPValue((PValue)output);
        GenericSystemDescriptor systemDescriptor = source instanceof BoundedSource ? new GenericSystemDescriptor(id, BoundedSourceSystem.Factory.class.getName()) : new GenericSystemDescriptor(id, UnboundedSourceSystem.Factory.class.getName());
        ImmutableMap systemConfig = ImmutableMap.of((Object)"source", (Object)Base64Serializer.serializeUnchecked((Serializable)source), (Object)"coder", (Object)Base64Serializer.serializeUnchecked(coder), (Object)"stepName", (Object)node.getFullName());
        systemDescriptor.withSystemConfigs((Map)systemConfig);
        KVSerde kvSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        GenericInputDescriptor inputDescriptor = systemDescriptor.getInputDescriptor(id, (Serde)kvSerde);
        if (source instanceof BoundedSource) {
            inputDescriptor.isBounded();
        }
        ctx.registerInputMessageStream((PValue)output, inputDescriptor);
    }
}

