/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.samza.translation.SamzaPublishView;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;

public class PViewToIdMapper
extends Pipeline.PipelineVisitor.Defaults {
    private final Map<PValue, String> idMap = new HashMap<PValue, String>();
    private int nextId;

    public static Map<PValue, String> buildIdMap(Pipeline pipeline) {
        PViewToIdMapper mapper = new PViewToIdMapper();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)mapper);
        return mapper.getIdMap();
    }

    private PViewToIdMapper() {
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        String valueDesc = PViewToIdMapper.pValueToString(value).replaceFirst(".*:([a-zA-Z#0-9]+).*", "$1");
        String samzaSafeValueDesc = valueDesc.replaceAll("[^A-Za-z0-9_-]", "_");
        this.idMap.put(value, String.format("%d-%s", this.nextId++, samzaSafeValueDesc));
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        if (node.getTransform() instanceof SamzaPublishView) {
            PCollectionView view = ((SamzaPublishView)node.getTransform()).getView();
            this.visitValue((PValue)view, node);
        }
    }

    public Map<PValue, String> getIdMap() {
        return Collections.unmodifiableMap(this.idMap);
    }

    private static String pValueToString(PValue value) {
        String name;
        try {
            name = value.getName();
        }
        catch (IllegalStateException e) {
            name = "<unnamed>";
        }
        return name + " [" + NameUtils.approximateSimpleName(value.getClass()) + "]";
    }
}

