/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.fnexecution.control.DefaultExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ReferenceCountingExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.transforms.SerializableFunction;

public class SamzaExecutableStageContextFactory
implements ExecutableStageContext.Factory {
    private static final SamzaExecutableStageContextFactory instance = new SamzaExecutableStageContextFactory();
    private static final ConcurrentMap<String, ExecutableStageContext.Factory> jobFactories = new ConcurrentHashMap<String, ExecutableStageContext.Factory>();

    private SamzaExecutableStageContextFactory() {
    }

    public static SamzaExecutableStageContextFactory getInstance() {
        return instance;
    }

    public ExecutableStageContext get(JobInfo jobInfo) {
        ExecutableStageContext.Factory jobFactory = jobFactories.computeIfAbsent(jobInfo.jobId(), k -> ReferenceCountingExecutableStageContextFactory.create(DefaultExecutableStageContext::create, (SerializableFunction & Serializable)caller -> false));
        return jobFactory.get(jobInfo);
    }
}

