/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public final class SamzaPipelineTranslatorUtils {
    private SamzaPipelineTranslatorUtils() {
    }

    public static WindowedValue.WindowedValueCoder instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static WindowingStrategy<?, BoundedWindow> getPortableWindowStrategy(PipelineNode.PTransformNode transform, QueryablePipeline pipeline) {
        WindowingStrategy windowingStrategy;
        String inputId = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)pipeline.getComponents());
        RunnerApi.WindowingStrategy windowingStrategyProto = pipeline.getComponents().getWindowingStrategiesOrThrow(pipeline.getComponents().getPcollectionsOrThrow(inputId).getWindowingStrategyId());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        WindowingStrategy ret = windowingStrategy;
        return ret;
    }

    public static String escape(String name) {
        return name.replaceFirst(".*:([a-zA-Z#0-9]+).*", "$1").replaceAll("[^A-Za-z0-9_-]", "_");
    }

    public static PCollection.IsBounded isBounded(RunnerApi.PCollection pCollection) {
        return pCollection.getIsBounded() == RunnerApi.IsBounded.Enum.BOUNDED ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
    }
}

