/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaTranslatorRegistrar;
import org.apache.beam.runners.samza.translation.TransformConfigGenerator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPortablePipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaPortablePipelineTranslator.class);
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?>> TRANSLATORS = SamzaPortablePipelineTranslator.loadTranslators();

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?>> loadTranslators() {
        HashMap translators = new HashMap();
        for (SamzaTranslatorRegistrar registrar : ServiceLoader.load(SamzaTranslatorRegistrar.class)) {
            translators.putAll(registrar.getTransformTranslators());
        }
        LOG.info("{} translators loaded.", (Object)translators.size());
        return ImmutableMap.copyOf(translators);
    }

    private SamzaPortablePipelineTranslator() {
    }

    public static void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PortableTranslationContext ctx) {
        QueryablePipeline queryablePipeline = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode transform : queryablePipeline.getTopologicallyOrderedTransforms()) {
            ctx.setCurrentTransform(transform);
            LOG.info("Translating transform urn: {}", (Object)transform.getTransform().getSpec().getUrn());
            TRANSLATORS.get(transform.getTransform().getSpec().getUrn()).translatePortable(transform, queryablePipeline, ctx);
            ctx.clearCurrentTransform();
        }
    }

    public static void createConfig(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized ConfigBuilder configBuilder, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        QueryablePipeline queryablePipeline = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode transform : queryablePipeline.getTopologicallyOrderedTransforms()) {
            TransformTranslator<?> translator = TRANSLATORS.get(transform.getTransform().getSpec().getUrn());
            if (!(translator instanceof TransformConfigGenerator)) continue;
            TransformConfigGenerator configGenerator = (TransformConfigGenerator)((Object)translator);
            configBuilder.putAll(configGenerator.createPortableConfig(transform, options));
        }
    }
}

