/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.util.HashIdGenerator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.table.Table;
import org.apache.samza.table.descriptors.TableDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PortableTranslationContext {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> messsageStreams = new HashMap();
    private final @UnknownKeyFor @NonNull @Initialized StreamApplicationDescriptor appDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> registeredInputStreams = new HashSet<String>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> registeredTables = new HashMap<String, Table>();
    private final @UnknownKeyFor @NonNull @Initialized HashIdGenerator idGenerator = new HashIdGenerator();
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode currentTransform;

    public PortableTranslationContext(@UnknownKeyFor @NonNull @Initialized StreamApplicationDescriptor appDescriptor, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        this.appDescriptor = appDescriptor;
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions getSamzaPipelineOptions() {
        return this.options;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>>> getAllInputMessageStreams(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        Collection inputStreamIds = transform.getTransform().getInputsMap().values();
        return inputStreamIds.stream().map(this::getMessageStreamById).collect(Collectors.toList());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>> getOneInputMessageStream(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        return this.getMessageStreamById(id);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>> getMessageStreamById(@UnknownKeyFor @NonNull @Initialized String id) {
        return this.messsageStreams.get(id);
    }

    public @UnknownKeyFor @NonNull @Initialized String getInputId(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
    }

    public @UnknownKeyFor @NonNull @Initialized String getOutputId(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
    }

    public <T> void registerMessageStream(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>> stream) {
        if (this.messsageStreams.containsKey(id)) {
            throw new IllegalArgumentException("Stream already registered for id: " + id);
        }
        this.messsageStreams.put(id, stream);
    }

    public <OutT> @UnknownKeyFor @NonNull @Initialized OutputStream<OutT> getOutputStream(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized OutputDescriptor<OutT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> outputDescriptor) {
        return this.appDescriptor.getOutputStream(outputDescriptor);
    }

    public <T> void registerInputMessageStream(@UnknownKeyFor @NonNull @Initialized String id, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InputDescriptor<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized OpMessage<T>>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> inputDescriptor) {
        String streamId = inputDescriptor.getStreamId();
        if (this.registeredInputStreams.contains(streamId)) {
            return;
        }
        MessageStream stream = this.appDescriptor.getInputStream(inputDescriptor).map(KV::getValue);
        this.registerMessageStream(id, stream);
        this.registeredInputStreams.add(streamId);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder instantiateCoder(@UnknownKeyFor @NonNull @Initialized String collectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized BoundedWindow> getPortableWindowStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        WindowingStrategy windowingStrategy;
        String inputId = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)pipeline.getComponents());
        RunnerApi.WindowingStrategy windowingStrategyProto = pipeline.getComponents().getWindowingStrategiesOrThrow(pipeline.getComponents().getPcollectionsOrThrow(inputId).getWindowingStrategyId());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        WindowingStrategy ret = windowingStrategy;
        return ret;
    }

    public <K, V> @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized KV<K, V>> getTable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TableDescriptor<K, V, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> tableDesc) {
        return this.registeredTables.computeIfAbsent(tableDesc.getTableId(), id -> this.appDescriptor.getTable(tableDesc));
    }

    public void setCurrentTransform(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode currentTransform) {
        this.currentTransform = currentTransform;
    }

    public void clearCurrentTransform() {
        this.currentTransform = null;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTransformFullName() {
        return this.currentTransform.getTransform().getUniqueName();
    }

    public @UnknownKeyFor @NonNull @Initialized String getTransformId() {
        return this.idGenerator.getId(this.currentTransform.getTransform().getUniqueName());
    }
}

