/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.samza.runtime.KeyedInternals;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class DoFnRunnerWithKeyedInternals<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> underlying;
    private final @UnknownKeyFor @NonNull @Initialized KeyedInternals keyedInternals;

    DoFnRunnerWithKeyedInternals(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> doFnRunner, @UnknownKeyFor @NonNull @Initialized KeyedInternals keyedInternals) {
        this.underlying = doFnRunner;
        this.keyedInternals = keyedInternals;
    }

    public void startBundle() {
        this.underlying.startBundle();
    }

    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        this.setKeyedInternals(elem.getValue());
        try {
            this.underlying.processElement(elem);
        }
        finally {
            this.clearKeyedInternals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimer(@UnknownKeyFor @NonNull @Initialized KeyedTimerData keyedTimerData, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        this.setKeyedInternals(keyedTimerData);
        try {
            TimerInternals.TimerData timer = keyedTimerData.getTimerData();
            this.onTimer(timer.getTimerId(), timer.getTimerFamilyId(), keyedTimerData.getKey(), window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
        }
        finally {
            this.clearKeyedInternals();
        }
    }

    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        Preconditions.checkState((this.keyedInternals.getKey() != null ? 1 : 0) != 0, (Object)"Key is not set for timer");
        this.underlying.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain);
    }

    public void finishBundle() {
        this.underlying.finishBundle();
    }

    public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        this.underlying.onWindowExpiration(window, timestamp, key);
    }

    public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
        return this.underlying.getFn();
    }

    private void setKeyedInternals(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof KeyedWorkItem) {
            this.keyedInternals.setKey(((KeyedWorkItem)value).key());
        } else if (value instanceof KeyedTimerData) {
            Object key = ((KeyedTimerData)value).getKey();
            if (key != null) {
                this.keyedInternals.setKey(key);
            }
        } else {
            this.keyedInternals.setKey(((KV)value).getKey());
        }
    }

    private void clearKeyedInternals() {
        this.keyedInternals.clearKey();
    }
}

