/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.container;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.beam.runners.samza.container.BeamContainerRunner;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigFactory;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.ShellCommandConfig;
import org.apache.samza.container.SamzaContainer;
import org.apache.samza.job.model.JobModel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerCfgFactory
implements ConfigFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ContainerCfgFactory.class);
    private static final @UnknownKeyFor @NonNull @Initialized Object LOCK = new Object();
    static volatile @UnknownKeyFor @NonNull @Initialized JobModel jobModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized Config getConfig(@UnknownKeyFor @NonNull @Initialized URI configUri) {
        if (jobModel == null) {
            Object object = LOCK;
            synchronized (object) {
                if (jobModel == null) {
                    String containerId = System.getenv(ShellCommandConfig.ENV_CONTAINER_ID());
                    LOG.info(String.format("Got container ID: %s", containerId));
                    String coordinatorUrl = System.getenv(ShellCommandConfig.ENV_COORDINATOR_URL());
                    LOG.info(String.format("Got coordinator URL: %s", coordinatorUrl));
                    int delay = new Random().nextInt(SamzaContainer.DEFAULT_READ_JOBMODEL_DELAY_MS()) + 1;
                    jobModel = SamzaContainer.readJobModel((String)coordinatorUrl, (int)delay);
                }
            }
        }
        HashMap<String, String> config = new HashMap<String, String>((Map<String, String>)jobModel.getConfig());
        config.put("app.runner.class", BeamContainerRunner.class.getName());
        return new MapConfig(config);
    }
}

