/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.time.Duration;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SamzaRunnerOverrideConfigs {
    public static final @UnknownKeyFor @NonNull @Initialized String BEAM_RUNNER_CONFIG_PREFIX = "beam.override.";
    public static final @UnknownKeyFor @NonNull @Initialized String IS_PORTABLE_MODE = "beam.override.portable";
    public static final @UnknownKeyFor @NonNull @Initialized String FN_CONTROL_PORT = "beam.override.control.port";
    public static final @UnknownKeyFor @NonNull @Initialized String CONTROL_CLIENT_MAX_WAIT_TIME_MS = "controL.wait.time.ms";
    public static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_CONTROL_CLIENT_MAX_WAIT_TIME_MS = Duration.ofMinutes(2L).toMillis();

    private static @UnknownKeyFor @NonNull @Initialized boolean containsKey(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options, @UnknownKeyFor @NonNull @Initialized String configKey) {
        if (options == null || options.getConfigOverride() == null) {
            return false;
        }
        return options.getConfigOverride().containsKey(configKey);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isPortableMode(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, IS_PORTABLE_MODE)) {
            return options.getConfigOverride().get(IS_PORTABLE_MODE).equals(String.valueOf(true));
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized int getFnControlPort(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, FN_CONTROL_PORT)) {
            return Integer.parseInt(options.getConfigOverride().get(FN_CONTROL_PORT));
        }
        return -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized long getControlClientWaitTimeoutMs(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, CONTROL_CLIENT_MAX_WAIT_TIME_MS)) {
            return Long.parseLong(options.getConfigOverride().get(CONTROL_CLIENT_MAX_WAIT_TIME_MS));
        }
        return DEFAULT_CONTROL_CLIENT_MAX_WAIT_TIME_MS;
    }
}

