/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.ConfigContext;
import org.apache.beam.runners.samza.translation.FlattenPCollectionsTranslator;
import org.apache.beam.runners.samza.translation.GroupByKeyTranslator;
import org.apache.beam.runners.samza.translation.ImpulseTranslator;
import org.apache.beam.runners.samza.translation.ParDoBoundMultiTranslator;
import org.apache.beam.runners.samza.translation.ReadTranslator;
import org.apache.beam.runners.samza.translation.SamzaPublishView;
import org.apache.beam.runners.samza.translation.SamzaPublishViewTranslator;
import org.apache.beam.runners.samza.translation.SamzaTranslatorRegistrar;
import org.apache.beam.runners.samza.translation.SplittableParDoTranslators;
import org.apache.beam.runners.samza.translation.TransformConfigGenerator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.translation.WindowAssignTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaPipelineTranslator.class);
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?>> TRANSLATORS = SamzaPipelineTranslator.loadTranslators();

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?>> loadTranslators() {
        HashMap translators = new HashMap();
        for (SamzaTranslatorRegistrar registrar : ServiceLoader.load(SamzaTranslatorRegistrar.class)) {
            translators.putAll(registrar.getTransformTranslators());
        }
        return ImmutableMap.copyOf(translators);
    }

    private SamzaPipelineTranslator() {
    }

    public static void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, final @UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
        Preconditions.checkState((ctx.getPipelineOptions().getMaxBundleSize() <= 1L ? 1 : 0) != 0, (Object)"bundling is not supported for non portable mode. Please disable bundling (by setting max bundle size to 1).");
        TransformVisitorFn translateFn = new TransformVisitorFn(){

            @Override
            public <T extends PTransform<?, ?>> void apply(T transform, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TransformTranslator<T> translator) {
                ctx.setCurrentTransform(node.toAppliedPTransform(pipeline));
                translator.translate(transform, node, ctx);
                ctx.clearCurrentTransform();
            }
        };
        SamzaPipelineVisitor visitor = new SamzaPipelineVisitor(translateFn);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
    }

    public static void createConfig(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> idMap, final @UnknownKeyFor @NonNull @Initialized ConfigBuilder configBuilder) {
        final ConfigContext ctx = new ConfigContext(idMap, options);
        TransformVisitorFn configFn = new TransformVisitorFn(){

            @Override
            public <T extends PTransform<?, ?>> void apply(T transform, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TransformTranslator<T> translator) {
                ctx.setCurrentTransform(node.toAppliedPTransform(pipeline));
                if (translator instanceof TransformConfigGenerator) {
                    TransformConfigGenerator configGenerator = (TransformConfigGenerator)((Object)translator);
                    configBuilder.putAll(configGenerator.createConfig(transform, node, ctx));
                }
                ctx.clearCurrentTransform();
            }
        };
        SamzaPipelineVisitor visitor = new SamzaPipelineVisitor(configFn);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
    }

    public static class SamzaTransformsRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.of(SamzaPublishView.class, (Object)((Object)new SamzaPublishView.SamzaPublishViewPayloadTranslator()));
        }
    }

    public static class SamzaTranslators
    implements SamzaTranslatorRegistrar {
        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?>> getTransformTranslators() {
            return ImmutableMap.builder().put((Object)"beam:transform:read:v1", new ReadTranslator()).put((Object)"beam:transform:pardo:v1", new ParDoBoundMultiTranslator()).put((Object)"beam:transform:group_by_key:v1", new GroupByKeyTranslator()).put((Object)"beam:transform:combine_per_key:v1", new GroupByKeyTranslator()).put((Object)"beam:transform:window_into:v1", new WindowAssignTranslator()).put((Object)"beam:transform:flatten:v1", new FlattenPCollectionsTranslator()).put((Object)"beam:transform:samza:publish-view:v1", new SamzaPublishViewTranslator()).put((Object)"beam:transform:impulse:v1", (Object)new ImpulseTranslator()).put((Object)"beam:transform:sdf_process_keyed_elements:v1", new SplittableParDoTranslators.ProcessKeyedElements()).put((Object)"beam:runner:executable_stage:v1", new ParDoBoundMultiTranslator()).build();
        }
    }

    private static class SamzaPipelineVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private @UnknownKeyFor @NonNull @Initialized TransformVisitorFn visitorFn;

        private SamzaPipelineVisitor(@UnknownKeyFor @NonNull @Initialized TransformVisitorFn visitorFn) {
            this.visitorFn = visitorFn;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            PTransform transform = node.getTransform();
            String urn = SamzaPipelineVisitor.getUrnForTransform(transform);
            if (SamzaPipelineVisitor.canTranslate(urn, transform)) {
                this.applyTransform(transform, node, (TransformTranslator)TRANSLATORS.get(urn));
                return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            PTransform transform = node.getTransform();
            String urn = SamzaPipelineVisitor.getUrnForTransform(transform);
            Preconditions.checkArgument((boolean)SamzaPipelineVisitor.canTranslate(urn, transform), (Object)String.format("Unsupported transform class: %s. Node: %s", transform, node));
            this.applyTransform(transform, node, (TransformTranslator)TRANSLATORS.get(urn));
        }

        private <T extends PTransform<?, ?>> void applyTransform(T transform, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?> translator) {
            TransformTranslator<?> typedTranslator = translator;
            this.visitorFn.apply(transform, node, this.getPipeline(), typedTranslator);
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean canTranslate(@UnknownKeyFor @NonNull @Initialized String urn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            if (!TRANSLATORS.containsKey(urn)) {
                return false;
            }
            if (urn.equals("beam:transform:combine_per_key:v1")) {
                return ((Combine.PerKey)transform).getSideInputs().isEmpty();
            }
            return true;
        }

        private static @UnknownKeyFor @NonNull @Initialized String getUrnForTransform(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return transform == null ? null : PTransformTranslation.urnForTransformOrNull(transform);
        }
    }

    private static interface TransformVisitorFn {
        public <T extends PTransform<?, ?>> void apply(T var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var2, @UnknownKeyFor @NonNull @Initialized Pipeline var3, @UnknownKeyFor @NonNull @Initialized TransformTranslator<T> var4);
    }
}

