/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaPortablePipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class SamzaPipelineOptionsValidator {
    public static void validate(SamzaPipelineOptions opts) {
        Preconditions.checkArgument((opts.getMaxSourceParallelism() >= 1 ? 1 : 0) != 0);
        SamzaPipelineOptionsValidator.validateBundlingRelatedOptions(opts);
    }

    private static void validateBundlingRelatedOptions(SamzaPipelineOptions pipelineOptions) {
        if (pipelineOptions.getMaxBundleSize() > 1L) {
            Preconditions.checkState((boolean)SamzaPipelineOptionsValidator.isPortable(pipelineOptions), (Object)"Bundling is not supported in non portable mode. Please disable by setting maxBundleSize to 1.");
            String taskConcurrencyConfig = "task.max.concurrency";
            Map<Object, Object> configs = pipelineOptions.getConfigOverride() == null ? new HashMap() : pipelineOptions.getConfigOverride();
            long taskConcurrency = Long.parseLong(configs.getOrDefault(taskConcurrencyConfig, "1"));
            Preconditions.checkState((taskConcurrency == 1L ? 1 : 0) != 0, (Object)("Bundling is not supported if " + taskConcurrencyConfig + " is greater than 1. Please disable bundling by setting maxBundleSize to 1. Or disable task concurrency."));
        }
    }

    private static boolean isPortable(SamzaPipelineOptions options) {
        return options instanceof SamzaPortablePipelineOptions;
    }
}

