/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaTranslatorRegistrar;
import org.apache.beam.runners.samza.translation.TransformConfigGenerator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPortablePipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaPortablePipelineTranslator.class);
    private static final Map<String, TransformTranslator<?>> TRANSLATORS = SamzaPortablePipelineTranslator.loadTranslators();

    private static Map<String, TransformTranslator<?>> loadTranslators() {
        HashMap translators = new HashMap();
        for (SamzaTranslatorRegistrar registrar : ServiceLoader.load(SamzaTranslatorRegistrar.class)) {
            translators.putAll(registrar.getTransformTranslators());
        }
        LOG.info("{} translators loaded.", (Object)translators.size());
        return ImmutableMap.copyOf(translators);
    }

    private SamzaPortablePipelineTranslator() {
    }

    public static void translate(RunnerApi.Pipeline pipeline, PortableTranslationContext ctx) {
        QueryablePipeline queryablePipeline = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        int topologicalId = 0;
        for (PipelineNode.PTransformNode transform : queryablePipeline.getTopologicallyOrderedTransforms()) {
            ctx.setCurrentTopologicalId(topologicalId++);
            LOG.info("Translating transform urn: {}", (Object)transform.getTransform().getSpec().getUrn());
            TRANSLATORS.get(transform.getTransform().getSpec().getUrn()).translatePortable(transform, queryablePipeline, ctx);
        }
    }

    public static void createConfig(RunnerApi.Pipeline pipeline, ConfigBuilder configBuilder, SamzaPipelineOptions options) {
        QueryablePipeline queryablePipeline = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode transform : queryablePipeline.getTopologicallyOrderedTransforms()) {
            TransformTranslator<?> translator = TRANSLATORS.get(transform.getTransform().getSpec().getUrn());
            if (!(translator instanceof TransformConfigGenerator)) continue;
            TransformConfigGenerator configGenerator = (TransformConfigGenerator)((Object)translator);
            configBuilder.putAll(configGenerator.createPortableConfig(transform, options));
        }
    }
}

