/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.ConfigContext;
import org.apache.beam.runners.samza.translation.FlattenPCollectionsTranslator;
import org.apache.beam.runners.samza.translation.GroupByKeyTranslator;
import org.apache.beam.runners.samza.translation.ImpulseTranslator;
import org.apache.beam.runners.samza.translation.ParDoBoundMultiTranslator;
import org.apache.beam.runners.samza.translation.ReadTranslator;
import org.apache.beam.runners.samza.translation.SamzaPublishView;
import org.apache.beam.runners.samza.translation.SamzaPublishViewTranslator;
import org.apache.beam.runners.samza.translation.SamzaTranslatorRegistrar;
import org.apache.beam.runners.samza.translation.TransformConfigGenerator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.translation.WindowAssignTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaPipelineTranslator.class);
    private static final Map<String, TransformTranslator<?>> TRANSLATORS = SamzaPipelineTranslator.loadTranslators();

    private static Map<String, TransformTranslator<?>> loadTranslators() {
        HashMap translators = new HashMap();
        for (SamzaTranslatorRegistrar registrar : ServiceLoader.load(SamzaTranslatorRegistrar.class)) {
            translators.putAll(registrar.getTransformTranslators());
        }
        return ImmutableMap.copyOf(translators);
    }

    private SamzaPipelineTranslator() {
    }

    public static void translate(Pipeline pipeline, final TranslationContext ctx) {
        TransformVisitorFn translateFn = new TransformVisitorFn(){
            private int topologicalId = 0;

            @Override
            public <T extends PTransform<?, ?>> void apply(T transform, TransformHierarchy.Node node, Pipeline pipeline, TransformTranslator<T> translator) {
                ctx.setCurrentTransform(node.toAppliedPTransform(pipeline));
                ctx.setCurrentTopologicalId(this.topologicalId++);
                translator.translate(transform, node, ctx);
                ctx.clearCurrentTransform();
            }
        };
        SamzaPipelineVisitor visitor = new SamzaPipelineVisitor(translateFn);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
    }

    public static void createConfig(Pipeline pipeline, SamzaPipelineOptions options, Map<PValue, String> idMap, final ConfigBuilder configBuilder) {
        final ConfigContext ctx = new ConfigContext(idMap, options);
        TransformVisitorFn configFn = new TransformVisitorFn(){

            @Override
            public <T extends PTransform<?, ?>> void apply(T transform, TransformHierarchy.Node node, Pipeline pipeline, TransformTranslator<T> translator) {
                ctx.setCurrentTransform(node.toAppliedPTransform(pipeline));
                if (translator instanceof TransformConfigGenerator) {
                    TransformConfigGenerator configGenerator = (TransformConfigGenerator)((Object)translator);
                    configBuilder.putAll(configGenerator.createConfig(transform, node, ctx));
                }
                ctx.clearCurrentTransform();
            }
        };
        SamzaPipelineVisitor visitor = new SamzaPipelineVisitor(configFn);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class SamzaTransformsRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.of(SamzaPublishView.class, (Object)((Object)new SamzaPublishView.SamzaPublishViewPayloadTranslator()));
        }
    }

    @AutoService(value=SamzaTranslatorRegistrar.class)
    public static class SamzaTranslators
    implements SamzaTranslatorRegistrar {
        @Override
        public Map<String, TransformTranslator<?>> getTransformTranslators() {
            return ImmutableMap.builder().put((Object)PTransformTranslation.READ_TRANSFORM_URN, new ReadTranslator()).put((Object)PTransformTranslation.PAR_DO_TRANSFORM_URN, new ParDoBoundMultiTranslator()).put((Object)PTransformTranslation.GROUP_BY_KEY_TRANSFORM_URN, new GroupByKeyTranslator()).put((Object)PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN, new GroupByKeyTranslator()).put((Object)PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, new WindowAssignTranslator()).put((Object)PTransformTranslation.FLATTEN_TRANSFORM_URN, new FlattenPCollectionsTranslator()).put((Object)"beam:transform:samza:publish-view:v1", new SamzaPublishViewTranslator()).put((Object)PTransformTranslation.IMPULSE_TRANSFORM_URN, (Object)new ImpulseTranslator()).put((Object)"beam:runner:executable_stage:v1", new ParDoBoundMultiTranslator()).build();
        }
    }

    private static class SamzaPipelineVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private TransformVisitorFn visitorFn;

        private SamzaPipelineVisitor(TransformVisitorFn visitorFn) {
            this.visitorFn = visitorFn;
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            String urn = SamzaPipelineVisitor.getUrnForTransform(transform);
            if (SamzaPipelineVisitor.canTranslate(urn, transform)) {
                this.applyTransform(transform, node, (TransformTranslator)TRANSLATORS.get(urn));
                return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            String urn = SamzaPipelineVisitor.getUrnForTransform(transform);
            Preconditions.checkArgument((boolean)SamzaPipelineVisitor.canTranslate(urn, transform), (Object)String.format("Unsupported transform class: %s. Node: %s", transform, node));
            this.applyTransform(transform, node, (TransformTranslator)TRANSLATORS.get(urn));
        }

        private <T extends PTransform<?, ?>> void applyTransform(T transform, TransformHierarchy.Node node, TransformTranslator<?> translator) {
            TransformTranslator<?> typedTranslator = translator;
            this.visitorFn.apply(transform, node, this.getPipeline(), typedTranslator);
        }

        private static boolean canTranslate(String urn, PTransform<?, ?> transform) {
            if (!TRANSLATORS.containsKey(urn)) {
                return false;
            }
            if (urn.equals(PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN)) {
                return ((Combine.PerKey)transform).getSideInputs().isEmpty();
            }
            return true;
        }

        private static String getUrnForTransform(PTransform<?, ?> transform) {
            return transform == null ? null : PTransformTranslation.urnForTransformOrNull(transform);
        }
    }

    private static interface TransformVisitorFn {
        public <T extends PTransform<?, ?>> void apply(T var1, TransformHierarchy.Node var2, Pipeline var3, TransformTranslator<T> var4);
    }
}

