/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;

public class PortablePipelineDotRenderer {
    private final StringBuilder dotBuilder = new StringBuilder();
    private final Map<String, Integer> valueToProducerNodeId = new HashMap<String, Integer>();
    private int indent;
    private int nextNodeId;

    public static String toDotString(RunnerApi.Pipeline pipeline) {
        PortablePipelineDotRenderer renderer = new PortablePipelineDotRenderer();
        return renderer.toDot(pipeline);
    }

    private PortablePipelineDotRenderer() {
    }

    private String toDot(RunnerApi.Pipeline pipeline) {
        QueryablePipeline p = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        this.begin();
        for (PipelineNode.PTransformNode transform : p.getTopologicallyOrderedTransforms()) {
            this.visitTransform(transform);
        }
        this.end();
        return this.dotBuilder.toString();
    }

    private void visitTransform(PipelineNode.PTransformNode node) {
        int nodeId = this.nextNodeId++;
        RunnerApi.PTransform transform = node.getTransform();
        this.writeLine("%d [label=\"%s\\n%s\"]", nodeId, PortablePipelineDotRenderer.escapeString(transform.getUniqueName()), PortablePipelineDotRenderer.escapeString(transform.getSpec().getUrn()));
        transform.getOutputs().values().forEach(x -> this.valueToProducerNodeId.put((String)x, nodeId));
        transform.getInputs().forEach((key, value) -> {
            int producerId = this.valueToProducerNodeId.get(value);
            String style = "solid";
            this.writeLine("%d -> %d [style=%s label=\"%s\"]", producerId, nodeId, style, PortablePipelineDotRenderer.escapeString(value.substring(value.lastIndexOf(95) + 1)));
        });
    }

    private void begin() {
        this.writeLine("digraph {", new Object[0]);
        this.enterBlock();
        this.writeLine("rankdir=LR", new Object[0]);
    }

    private void end() {
        this.exitBlock();
        this.writeLine("}", new Object[0]);
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    private void writeLine(String format, Object ... args) {
        if (this.indent != 0) {
            this.dotBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.dotBuilder.append(String.format(format, args));
        this.dotBuilder.append("\n");
    }

    private static String escapeString(String x) {
        return x.replace("\"", "\\\"");
    }

    private static String shortenTag(String tag) {
        return tag.replaceFirst(".*:([a-zA-Z#0-9]+).*", "$1");
    }
}

