/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.StreamGraph;

public class PortableTranslationContext {
    private final Map<String, MessageStream<?>> messsageStreams = new HashMap();
    private final StreamGraph streamGraph;
    private final SamzaPipelineOptions options;
    private int topologicalId;
    private final Set<String> registeredInputStreams = new HashSet<String>();

    public PortableTranslationContext(StreamGraph streamGraph, SamzaPipelineOptions options) {
        this.streamGraph = streamGraph;
        this.options = options;
    }

    public SamzaPipelineOptions getSamzaPipelineOptions() {
        return this.options;
    }

    public void setCurrentTopologicalId(int id) {
        this.topologicalId = id;
    }

    public int getCurrentTopologicalId() {
        return this.topologicalId;
    }

    public <T> List<MessageStream<OpMessage<T>>> getAllInputMessageStreams(PipelineNode.PTransformNode transform) {
        Collection inputStreamIds = transform.getTransform().getInputsMap().values();
        return inputStreamIds.stream().map(this::getMessageStreamById).collect(Collectors.toList());
    }

    public <T> MessageStream<OpMessage<T>> getOneInputMessageStream(PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        return this.getMessageStreamById(id);
    }

    public <T> MessageStream<OpMessage<T>> getMessageStreamById(String id) {
        return this.messsageStreams.get(id);
    }

    public String getInputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
    }

    public String getOutputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
    }

    public <T> void registerMessageStream(String id, MessageStream<OpMessage<T>> stream) {
        if (this.messsageStreams.containsKey(id)) {
            throw new IllegalArgumentException("Stream already registered for id: " + id);
        }
        this.messsageStreams.put(id, stream);
    }

    public void registerInputMessageStream(String id) {
        this.registerInputMessageStreamWithStreamId(id, id);
    }

    public <T> OutputStream<T> getOutputStreamById(String outputStreamId) {
        return this.streamGraph.getOutputStream(outputStreamId);
    }

    public <T> void registerInputMessageStreamWithStreamId(String id, String streamId) {
        if (this.registeredInputStreams.contains(streamId)) {
            return;
        }
        MessageStream stream = this.streamGraph.getInputStream(streamId).map(KV::getValue);
        this.registerMessageStream(id, stream);
        this.registeredInputStreams.add(streamId);
    }
}

