/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.samza.runtime.KeyedInternals;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class DoFnRunnerWithKeyedInternals<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final DoFnRunner<InputT, OutputT> underlying;
    private final KeyedInternals keyedInternals;

    DoFnRunnerWithKeyedInternals(DoFnRunner<InputT, OutputT> doFnRunner, KeyedInternals keyedInternals) {
        this.underlying = doFnRunner;
        this.keyedInternals = keyedInternals;
    }

    public void startBundle() {
        this.underlying.startBundle();
    }

    public void processElement(WindowedValue<InputT> elem) {
        this.setKeyedInternals(elem.getValue());
        try {
            this.underlying.processElement(elem);
        }
        finally {
            this.clearKeyedInternals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimer(KeyedTimerData keyedTimerData, BoundedWindow window) {
        this.setKeyedInternals(keyedTimerData);
        try {
            TimerInternals.TimerData timer = keyedTimerData.getTimerData();
            this.onTimer(timer.getTimerId(), window, timer.getTimestamp(), timer.getDomain());
        }
        finally {
            this.clearKeyedInternals();
        }
    }

    public void onTimer(String timerId, BoundedWindow window, Instant timestamp, TimeDomain timeDomain) {
        Preconditions.checkState((this.keyedInternals.getKey() != null ? 1 : 0) != 0, (Object)"Key is not set for timer");
        this.underlying.onTimer(timerId, window, timestamp, timeDomain);
    }

    public void finishBundle() {
        this.underlying.finishBundle();
    }

    public DoFn<InputT, OutputT> getFn() {
        return this.underlying.getFn();
    }

    private void setKeyedInternals(Object value) {
        if (value instanceof KeyedWorkItem) {
            this.keyedInternals.setKey(((KeyedWorkItem)value).key());
        } else if (value instanceof KeyedTimerData) {
            Object key = ((KeyedTimerData)value).getKey();
            if (key != null) {
                this.keyedInternals.setKey(key);
            }
        } else {
            this.keyedInternals.setKey(((KV)value).getKey());
        }
    }

    private void clearKeyedInternals() {
        this.keyedInternals.clearKey();
    }
}

