/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.GreedyPipelineFuser;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaRunner;
import org.apache.beam.runners.samza.util.PortablePipelineDotRenderer;
import org.apache.beam.sdk.PipelineResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineRunner
implements PortablePipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaPipelineRunner.class);
    private final SamzaPipelineOptions options;

    public PipelineResult run(RunnerApi.Pipeline pipeline, JobInfo jobInfo) {
        RunnerApi.Pipeline fusedPipeline = GreedyPipelineFuser.fuse((RunnerApi.Pipeline)pipeline).toPipeline();
        LOG.info("Portable pipeline to run:");
        LOG.info(PortablePipelineDotRenderer.toDotString(fusedPipeline));
        this.options.setRunner(SamzaRunner.class);
        try {
            SamzaRunner runner = new SamzaRunner(this.options);
            return runner.runPortablePipeline(fusedPipeline);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke samza job", e);
        }
    }

    public SamzaPipelineRunner(SamzaPipelineOptions options) {
        this.options = options;
    }
}

