/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnControlGrpc;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.FnApiControlClient;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.HeaderAccessor;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnApiControlClientPoolService
extends BeamFnControlGrpc.BeamFnControlImplBase
implements FnService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FnApiControlClientPoolService.class);
    private final @UnknownKeyFor @NonNull @Initialized Object lock = new Object();
    private final @UnknownKeyFor @NonNull @Initialized ControlClientPool.Sink clientSink;
    private final @UnknownKeyFor @NonNull @Initialized HeaderAccessor headerAccessor;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor> processBundleDescriptors = new ConcurrentHashMap<String, BeamFnApi.ProcessBundleDescriptor>();
    @GuardedBy(value="lock")
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FnApiControlClient> vendedClients = new HashMap<String, FnApiControlClient>();
    @GuardedBy(value="lock")
    private @UnknownKeyFor @NonNull @Initialized boolean closed = false;

    private FnApiControlClientPoolService(@UnknownKeyFor @NonNull @Initialized ControlClientPool.Sink clientSink, @UnknownKeyFor @NonNull @Initialized HeaderAccessor headerAccessor) {
        this.clientSink = clientSink;
        this.headerAccessor = headerAccessor;
    }

    public static @UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService offeringClientsToPool(@UnknownKeyFor @NonNull @Initialized ControlClientPool.Sink clientPool, @UnknownKeyFor @NonNull @Initialized HeaderAccessor headerAccessor) {
        return new FnApiControlClientPoolService(clientPool, headerAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.InstructionResponse> control(@UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.InstructionRequest> requestObserver) {
        String workerId = this.headerAccessor.getSdkWorkerId();
        LOG.info("Beam Fn Control client connected with id {}", (Object)workerId);
        FnApiControlClient newClient = FnApiControlClient.forRequestObserver(workerId, requestObserver, this.processBundleDescriptors);
        try {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"%s already closed", (Object)FnApiControlClientPoolService.class.getSimpleName());
                this.vendedClients.put(workerId, newClient);
            }
            this.clientSink.put(this.headerAccessor.getSdkWorkerId(), newClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newClient.asResponseObserver();
    }

    public void getProcessBundleDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.GetProcessBundleDescriptorRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor> responseObserver) {
        String bundleDescriptorId = request.getProcessBundleDescriptorId();
        LOG.info("getProcessBundleDescriptor request with id {}", (Object)bundleDescriptorId);
        BeamFnApi.ProcessBundleDescriptor descriptor = (BeamFnApi.ProcessBundleDescriptor)this.processBundleDescriptors.get(bundleDescriptorId);
        if (descriptor == null) {
            String msg = String.format("ProcessBundleDescriptor with id %s not found", bundleDescriptorId);
            responseObserver.onError((Throwable)new StatusException(Status.NOT_FOUND.withDescription(msg)));
            LOG.error(msg);
        } else {
            responseObserver.onNext((Object)descriptor);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                for (FnApiControlClient vended : this.vendedClients.values()) {
                    vended.close();
                }
            }
        }
    }
}

