/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.Collections;
import org.apache.beam.runners.dataflow.internal.DataflowGroupByKey;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Redistribute;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.ReshuffleTrigger;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.IdentityWindowFn;
import org.apache.beam.sdk.util.construction.PTransformReplacements;
import org.apache.beam.sdk.util.construction.SingleInputOutputOverrideFactory;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

class RedistributeByKeyOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor V>
extends SingleInputOutputOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, V>>, Redistribute.RedistributeByKey<K, V>> {
    private final @UnknownKeyFor @NonNull @Initialized boolean usesAtLeastOnceStreamingMode;

    public RedistributeByKeyOverrideFactory(@UnknownKeyFor @NonNull @Initialized boolean usesAtLeastOnceStreamingMode) {
        this.usesAtLeastOnceStreamingMode = usesAtLeastOnceStreamingMode;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Redistribute.RedistributeByKey<K, V>> transform) {
        return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new DataflowRedistributeByKey((Redistribute.RedistributeByKey)transform.getTransform(), this.usesAtLeastOnceStreamingMode));
    }

    private static class RestoreMetadata<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, ValueInSingleWindow<V>>>, PCollection<KV<K, V>>> {
        private RestoreMetadata() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, ValueInSingleWindow<V>>, KV<K, V>>(){

                public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
                    return Duration.millis((long)Long.MAX_VALUE);
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>> kv, // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, V>> r) {
                    r.outputWindowedValue((Object)KV.of((Object)kv.getKey(), (Object)((ValueInSingleWindow)kv.getValue()).getValue()), ((ValueInSingleWindow)kv.getValue()).getTimestamp(), Collections.singleton(((ValueInSingleWindow)kv.getValue()).getWindow()), ((ValueInSingleWindow)kv.getValue()).getPaneInfo());
                }
            }));
        }
    }

    public static class DataflowRedistributeByKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Redistribute.RedistributeByKey<K, V> originalTransform;
        private final @UnknownKeyFor @NonNull @Initialized boolean usesAtLeastOnceStreamingMode;

        private DataflowRedistributeByKey(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Redistribute.RedistributeByKey<K, V> originalTransform, @UnknownKeyFor @NonNull @Initialized boolean usesAtLeastOnceStreamingMode) {
            this.originalTransform = originalTransform;
            this.usesAtLeastOnceStreamingMode = usesAtLeastOnceStreamingMode;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean getAllowDuplicates() {
            return this.usesAtLeastOnceStreamingMode || this.originalTransform.getAllowDuplicates();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            WindowingStrategy originalStrategy = input.getWindowingStrategy();
            Window rewindow = Window.into((WindowFn)new IdentityWindowFn(originalStrategy.getWindowFn().windowCoder())).triggering((Trigger)new ReshuffleTrigger()).discardingFiredPanes().withTimestampCombiner(TimestampCombiner.EARLIEST).withAllowedLateness(Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
            PCollection reified = (PCollection)((PCollection)input.apply("SetIdentityWindow", (PTransform)rewindow)).apply("ReifyOriginalMetadata", Reify.windowsInValue());
            PCollection grouped = this.getAllowDuplicates() ? (PCollection)reified.apply(DataflowGroupByKey.createWithAllowDuplicates()) : (PCollection)reified.apply(DataflowGroupByKey.create());
            return ((PCollection)((PCollection)grouped.apply("ExpandIterable", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<ValueInSingleWindow<V>>>, KV<K, ValueInSingleWindow<V>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> element, // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> r) {
                    Object key = element.getKey();
                    for (ValueInSingleWindow value : (Iterable)element.getValue()) {
                        r.output((Object)KV.of((Object)key, (Object)value));
                    }
                }
            }))).apply("RestoreMetadata", new RestoreMetadata())).setWindowingStrategyInternal(originalStrategy);
        }
    }
}

