/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.HashSet;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UnconsumedReads {
    public static void ensureAllReadsConsumed(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        final HashSet unconsumed = new HashSet();
        pipeline.traverseTopologically(new Pipeline.PipelineVisitor.Defaults(){

            @Override
            public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                unconsumed.removeAll(node.getInputs().values());
            }

            @Override
            public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value,  @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
                String urn = PTransformTranslation.urnForTransformOrNull(producer.getTransform());
                if ("beam:transform:read:v1".equals(urn)) {
                    unconsumed.add((PCollection)value);
                }
            }
        });
        int i = 0;
        for (PCollection unconsumedPCollection : unconsumed) {
            UnconsumedReads.consume(unconsumedPCollection, i);
            ++i;
        }
    }

    private static <T> void consume(@UnknownKeyFor @NonNull @Initialized PCollection<T> unconsumedPCollection, @UnknownKeyFor @NonNull @Initialized int uniq) {
        String uniqueName = "DropInputs" + (uniq == 0 ? "" : Integer.valueOf(uniq));
        unconsumedPCollection.apply(uniqueName, ParDo.of(new NoOpDoFn()));
    }

    private static class NoOpDoFn<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private NoOpDoFn() {
        }

        @DoFn.ProcessElement
        public void doNothing(@UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext unused) {
        }
    }
}

