/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SerializableFunctions {
    public static <InT, OutT extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableFunction<InT, OutT> clonesOf(OutT base) {
        return input -> SerializableUtils.clone(base);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, T> identity() {
        return new Identity();
    }

    public static <InT, OutT> @UnknownKeyFor @NonNull @Initialized SerializableFunction<InT, OutT> constant(OutT value) {
        return new Constant(value);
    }

    private static class Constant<@UnknownKeyFor InT, @UnknownKeyFor OutT>
    implements SerializableFunction<InT, OutT> {
        OutT value;

        Constant(OutT value) {
            this.value = value;
        }

        @Override
        public OutT apply(InT input) {
            return this.value;
        }
    }

    private static class Identity<@UnknownKeyFor T>
    implements SerializableFunction<T, T> {
        private Identity() {
        }

        @Override
        public T apply(T input) {
            return input;
        }
    }
}

