/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.OutputBuilderSupplier;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValueReceiver;
import org.apache.beam.sdk.values.OutputBuilder;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DoFnOutputReceivers {
    public static <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> windowedReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag) {
        return new WindowedContextOutputReceiver<T>(context, builderSupplier, outputTag);
    }

    public static @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver windowedMultiReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders) {
        return new WindowedContextMultiOutputReceiver(context, builderSupplier, outputCoders);
    }

    public static @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver windowedMultiReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier) {
        return new WindowedContextMultiOutputReceiver(context, builderSupplier);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> rowReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag, @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder) {
        return new RowOutputReceiver(context, builderSupplier, outputTag, schemaCoder);
    }

    private static class WindowedContextMultiOutputReceiver
    implements DoFn.MultiOutputReceiver {
        private final @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context;
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;

        public WindowedContextMultiOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders) {
            this.context = context;
            this.builderSupplier = builderSupplier;
            this.outputCoders = outputCoders;
        }

        public WindowedContextMultiOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier) {
            this.context = context;
            this.builderSupplier = builderSupplier;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> get(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
            return DoFnOutputReceivers.windowedReceiver(this.context, this.builderSupplier, tag);
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> getRowReceiver(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
            Coder outputCoder = (Coder)((Map)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(this.outputCoders)).get(tag);
            Preconditions.checkStateNotNull(outputCoder, "No output tag for %s ", tag);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)(outputCoder instanceof SchemaCoder), (Object)("Output with tag " + tag + " must have a schema in order to call getRowReceiver"));
            return DoFnOutputReceivers.rowReceiver(this.context, this.builderSupplier, tag, (SchemaCoder)outputCoder);
        }
    }

    private static class WindowedContextOutputReceiver<@UnknownKeyFor T>
    implements DoFn.OutputReceiver<T>,
    WindowedValueReceiver<T> {
        private final @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier;
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context;
        @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag;

        public WindowedContextOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag) {
            this.context = context;
            this.builderSupplier = builderSupplier;
            this.outputTag = outputTag;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<T> builder(T value) {
            return WindowedValues.builder(this.builderSupplier.builder(value)).setReceiver(this);
        }

        @Override
        public void output(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedValue) {
            if (this.outputTag != null) {
                this.context.outputWindowedValue(this.outputTag, windowedValue.getValue(), windowedValue.getTimestamp(), windowedValue.getWindows(), windowedValue.getPaneInfo());
            } else {
                this.context.outputWindowedValue(windowedValue.getValue(), windowedValue.getTimestamp(), windowedValue.getWindows(), windowedValue.getPaneInfo());
            }
        }
    }

    private static class RowOutputReceiver<@UnknownKeyFor T>
    implements DoFn.OutputReceiver<Row> {
        private final @Nullable @UnknownKeyFor @Initialized TupleTag<T> tag;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context;
        private final @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier;
        @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder;

        private RowOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @UnknownKeyFor @NonNull @Initialized OutputBuilderSupplier builderSupplier, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag, @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder) {
            this.context = context;
            this.builderSupplier = builderSupplier;
            this.tag = outputTag;
            this.schemaCoder = schemaCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<@UnknownKeyFor @NonNull @Initialized Row> builder(@UnknownKeyFor @NonNull @Initialized Row value) {
            TupleTag<T> tag = this.tag;
            if (tag == null) {
                return ((WindowedValues.Builder)this.builderSupplier.builder(value).setValue((Object)value)).setReceiver(rowWithMetadata -> this.context.outputWindowedValue(this.schemaCoder.getFromRowFunction().apply((Row)rowWithMetadata.getValue()), rowWithMetadata.getTimestamp(), rowWithMetadata.getWindows(), rowWithMetadata.getPaneInfo()));
            }
            Preconditions.checkStateNotNull(tag);
            return this.builderSupplier.builder(value).setReceiver(rowWithMetadata -> this.context.outputWindowedValue(tag, this.schemaCoder.getFromRowFunction().apply((Row)rowWithMetadata.getValue()), rowWithMetadata.getTimestamp(), rowWithMetadata.getWindows(), rowWithMetadata.getPaneInfo()));
        }
    }
}

