/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SchemaUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String INDENT = "  ";

    public static @UnknownKeyFor @NonNull @Initialized Schema mergeWideningNullable(@UnknownKeyFor @NonNull @Initialized Schema schema1, @UnknownKeyFor @NonNull @Initialized Schema schema2) {
        if (schema1.getFieldCount() != schema2.getFieldCount()) {
            throw new IllegalArgumentException("Cannot merge schemas with different numbers of fields. schema1: " + schema1 + " schema2: " + schema2);
        }
        Schema.Builder builder = Schema.builder();
        for (int i = 0; i < schema1.getFieldCount(); ++i) {
            String name = schema1.getField(i).getName();
            builder.addField(name, SchemaUtils.widenNullableTypes(schema1.getField(i).getType(), schema2.getField(i).getType()));
        }
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Schema.FieldType widenNullableTypes(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType1, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType2) {
        Schema.FieldType result;
        if (fieldType1.getTypeName() != fieldType2.getTypeName()) {
            throw new IllegalArgumentException("Cannot merge two types: " + (Object)((Object)fieldType1.getTypeName()) + " and " + (Object)((Object)fieldType2.getTypeName()));
        }
        switch (fieldType1.getTypeName()) {
            case ROW: {
                result = Schema.FieldType.row(SchemaUtils.mergeWideningNullable(fieldType1.getRowSchema(), fieldType2.getRowSchema()));
                break;
            }
            case ARRAY: {
                Schema.FieldType arrayElementType = SchemaUtils.widenNullableTypes(fieldType1.getCollectionElementType(), fieldType2.getCollectionElementType());
                result = Schema.FieldType.array(arrayElementType);
                break;
            }
            case ITERABLE: {
                Schema.FieldType iterableElementType = SchemaUtils.widenNullableTypes(fieldType1.getCollectionElementType(), fieldType2.getCollectionElementType());
                result = Schema.FieldType.iterable(iterableElementType);
                break;
            }
            case MAP: {
                Schema.FieldType keyType = SchemaUtils.widenNullableTypes(fieldType1.getMapKeyType(), fieldType2.getMapKeyType());
                Schema.FieldType valueType = SchemaUtils.widenNullableTypes(fieldType1.getMapValueType(), fieldType2.getMapValueType());
                result = Schema.FieldType.map(keyType, valueType);
                break;
            }
            case LOGICAL_TYPE: {
                if (!fieldType1.getLogicalType().getIdentifier().equals(fieldType2.getLogicalType().getIdentifier())) {
                    throw new IllegalArgumentException("Logical types don't match and cannot be merged: " + fieldType1.getLogicalType().getIdentifier() + ".v.s" + fieldType2.getLogicalType().getIdentifier());
                }
            }
            default: {
                result = fieldType1;
            }
        }
        return result.withNullable(fieldType1.getNullable() != false || fieldType2.getNullable() != false);
    }

    public static <InputT, BaseT> BaseT toLogicalBaseType(@UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> logicalType, InputT inputType) {
        return logicalType.toBaseType(inputType);
    }

    public static <BaseT, InputT> InputT toLogicalInputType(@UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> logicalType, BaseT baseType) {
        return logicalType.toInputType(baseType);
    }

    public static @UnknownKeyFor @NonNull @Initialized String toPrettyString(@UnknownKeyFor @NonNull @Initialized Row row) {
        return SchemaUtils.toPrettyRowString(row, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized String toPrettyString(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return SchemaUtils.toPrettySchemaString(schema, "");
    }

    static @UnknownKeyFor @NonNull @Initialized String toFieldTypeNameString(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        return (Object)((Object)fieldType.getTypeName()) + (Boolean.TRUE.equals(fieldType.getNullable()) ? "" : " NOT NULL");
    }

    static @UnknownKeyFor @NonNull @Initialized String toPrettyFieldTypeString(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized String prefix) {
        String nextPrefix = prefix + INDENT;
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATETIME: 
            case BOOLEAN: 
            case BYTES: {
                return "<" + SchemaUtils.toFieldTypeNameString(fieldType) + ">";
            }
            case ARRAY: 
            case ITERABLE: {
                StringBuilder sb = new StringBuilder();
                sb.append("<").append(SchemaUtils.toFieldTypeNameString(fieldType)).append("> {\n");
                sb.append(nextPrefix).append("<element>: ").append(SchemaUtils.toPrettyFieldTypeString(Objects.requireNonNull(fieldType.getCollectionElementType()), nextPrefix)).append("\n");
                sb.append(prefix).append("}");
                return sb.toString();
            }
            case MAP: {
                StringBuilder sb = new StringBuilder();
                sb.append("<").append(SchemaUtils.toFieldTypeNameString(fieldType)).append("> {\n");
                sb.append(nextPrefix).append("<key>: ").append(SchemaUtils.toPrettyFieldTypeString(Objects.requireNonNull(fieldType.getMapKeyType()), nextPrefix)).append(",\n");
                sb.append(nextPrefix).append("<value>: ").append(SchemaUtils.toPrettyFieldTypeString(Objects.requireNonNull(fieldType.getMapValueType()), nextPrefix)).append("\n");
                sb.append(prefix).append("}");
                return sb.toString();
            }
            case ROW: {
                return "<" + SchemaUtils.toFieldTypeNameString(fieldType) + "> " + SchemaUtils.toPrettySchemaString(Objects.requireNonNull(fieldType.getRowSchema()), prefix);
            }
            case LOGICAL_TYPE: {
                Schema.FieldType baseType = Objects.requireNonNull(fieldType.getLogicalType()).getBaseType();
                StringBuilder sb = new StringBuilder();
                sb.append("<").append(SchemaUtils.toFieldTypeNameString(fieldType)).append("(").append(fieldType.getLogicalType().getIdentifier()).append(")> {\n");
                sb.append(nextPrefix).append("<base>: ").append(SchemaUtils.toPrettyFieldTypeString(baseType, nextPrefix)).append("\n");
                sb.append(prefix).append("}");
                return sb.toString();
            }
        }
        throw new UnsupportedOperationException((Object)((Object)fieldType.getTypeName()) + " is not supported");
    }

    static @UnknownKeyFor @NonNull @Initialized String toPrettyOptionsString(@UnknownKeyFor @NonNull @Initialized Schema.Options options, @UnknownKeyFor @NonNull @Initialized String prefix) {
        String nextPrefix = prefix + INDENT;
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (String optionName : options.getOptionNames()) {
            sb.append(nextPrefix).append(optionName).append(" = ").append(SchemaUtils.toPrettyFieldValueString(options.getType(optionName), options.getValue(optionName), nextPrefix)).append("\n");
        }
        sb.append(prefix).append("}");
        return sb.toString();
    }

    static @UnknownKeyFor @NonNull @Initialized String toPrettyFieldValueString(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String prefix) {
        String nextPrefix = prefix + INDENT;
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case DATETIME: 
            case BOOLEAN: {
                return Objects.toString(value);
            }
            case STRING: {
                String string = (String)value;
                return "\"" + string.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
            }
            case BYTES: {
                byte[] bytes = (byte[])value;
                return Arrays.toString(bytes);
            }
            case ARRAY: 
            case ITERABLE: {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException(String.format("value type is '%s' for field type '%s'", new Object[]{value.getClass(), fieldType.getTypeName()}));
                }
                Schema.FieldType elementType = Objects.requireNonNull(fieldType.getCollectionElementType());
                List list = (List)value;
                if (list.isEmpty()) {
                    return "[]";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("[\n");
                int size = list.size();
                int index = 0;
                for (Object element : list) {
                    sb.append(nextPrefix).append(SchemaUtils.toPrettyFieldValueString(elementType, element, nextPrefix));
                    if (index++ < size - 1) {
                        sb.append(",\n");
                        continue;
                    }
                    sb.append("\n");
                }
                sb.append(prefix).append("]");
                return sb.toString();
            }
            case MAP: {
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException(String.format("value type is '%s' for field type '%s'", new Object[]{value.getClass(), fieldType.getTypeName()}));
                }
                Schema.FieldType keyType = Objects.requireNonNull(fieldType.getMapKeyType());
                Schema.FieldType valueType = Objects.requireNonNull(fieldType.getMapValueType());
                Map map = (Map)value;
                if (map.isEmpty()) {
                    return "{}";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("{\n");
                int size = map.size();
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    sb.append(nextPrefix).append(SchemaUtils.toPrettyFieldValueString(keyType, entry.getKey(), nextPrefix)).append(": ").append(SchemaUtils.toPrettyFieldValueString(valueType, entry.getValue(), nextPrefix));
                    if (index++ < size - 1) {
                        sb.append(",\n");
                        continue;
                    }
                    sb.append("\n");
                }
                sb.append(prefix).append("}");
                return sb.toString();
            }
            case ROW: {
                return SchemaUtils.toPrettyRowString((Row)value, prefix);
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType<?, ?> logicalType = Objects.requireNonNull(fieldType.getLogicalType());
                Schema.FieldType baseType = logicalType.getBaseType();
                Object baseValue = logicalType.toBaseType(value);
                return SchemaUtils.toPrettyFieldValueString(baseType, baseValue, prefix);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)fieldType.getTypeName()) + " is not supported");
    }

    static @UnknownKeyFor @NonNull @Initialized String toPrettySchemaString(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String prefix) {
        String nextPrefix = prefix + INDENT;
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (Schema.Field field : schema.getFields()) {
            sb.append(nextPrefix).append(field.getName()).append(": ").append(SchemaUtils.toPrettyFieldTypeString(field.getType(), nextPrefix));
            if (field.getOptions().hasOptions()) {
                sb.append(", fieldOptions = ").append(SchemaUtils.toPrettyOptionsString(field.getOptions(), nextPrefix));
            }
            sb.append("\n");
        }
        sb.append(prefix).append("}");
        if (schema.getOptions().hasOptions()) {
            sb.append(", schemaOptions = ").append(SchemaUtils.toPrettyOptionsString(schema.getOptions(), prefix));
        }
        if (schema.getUUID() != null) {
            sb.append(", schemaUUID = ").append(schema.getUUID());
        }
        return sb.toString();
    }

    static @UnknownKeyFor @NonNull @Initialized String toPrettyRowString(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized String prefix) {
        long nonNullFieldCount = row.getValues().stream().filter(Objects::nonNull).count();
        if (nonNullFieldCount == 0L) {
            return "{}";
        }
        String nextPrefix = prefix + INDENT;
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        long nonNullFieldIndex = 0L;
        for (Schema.Field field : row.getSchema().getFields()) {
            String fieldName = field.getName();
            Object fieldValue = row.getValue(fieldName);
            if (fieldValue == null) continue;
            sb.append(nextPrefix).append(fieldName).append(": ").append(SchemaUtils.toPrettyFieldValueString(field.getType(), fieldValue, nextPrefix));
            if (nonNullFieldIndex++ < nonNullFieldCount - 1L) {
                sb.append(",\n");
                continue;
            }
            sb.append("\n");
        }
        sb.append(prefix).append("}");
        return sb.toString();
    }
}

