/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DelegatingHistogram
implements Metric,
Histogram,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;
    private final  @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType;
    private final @UnknownKeyFor @NonNull @Initialized boolean processWideContainer;

    public DelegatingHistogram(@UnknownKeyFor @NonNull @Initialized MetricName name,  @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer) {
        this.name = name;
        this.bucketType = bucketType;
        this.processWideContainer = processWideContainer;
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Histogram> getHistogram() {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container == null) {
            return Optional.empty();
        }
        return Optional.of(container.getHistogram(this.name, this.bucketType));
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized double value) {
        this.getHistogram().ifPresent(histogram -> histogram.update(value));
    }

    @Override
    public void update(double ... values) {
        this.getHistogram().ifPresent(histogram -> histogram.update(values));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }
}

