/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.sdk.io.TFRecordWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_TFRecordWriteSchemaTransformConfiguration
extends TFRecordWriteSchemaTransformConfiguration {
    private final String outputPrefix;
    private final @Nullable String filenameSuffix;
    private final int numShards;
    private final @Nullable String shardTemplate;
    private final String compression;
    private final @Nullable Boolean noSpilling;
    private final @Nullable Integer maxNumWritersPerBundle;
    private final @Nullable ErrorHandling errorHandling;

    private AutoValue_TFRecordWriteSchemaTransformConfiguration(String outputPrefix, @Nullable String filenameSuffix, int numShards, @Nullable String shardTemplate, String compression, @Nullable Boolean noSpilling, @Nullable Integer maxNumWritersPerBundle, @Nullable ErrorHandling errorHandling) {
        this.outputPrefix = outputPrefix;
        this.filenameSuffix = filenameSuffix;
        this.numShards = numShards;
        this.shardTemplate = shardTemplate;
        this.compression = compression;
        this.noSpilling = noSpilling;
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="The directory to which files will be written.")
    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    @Override
    @SchemaFieldDescription(value="The suffix of each file written, combined with prefix and shardTemplate.")
    public @Nullable String getFilenameSuffix() {
        return this.filenameSuffix;
    }

    @Override
    @SchemaFieldDescription(value="The number of shards to use, or 0 for automatic.")
    public int getNumShards() {
        return this.numShards;
    }

    @Override
    @SchemaFieldDescription(value="The shard template of each file written, combined with prefix and suffix.")
    public @Nullable String getShardTemplate() {
        return this.shardTemplate;
    }

    @Override
    @SchemaFieldDescription(value="Option to indicate the output sink's compression type. Default is NONE.")
    public String getCompression() {
        return this.compression;
    }

    @Override
    @SchemaFieldDescription(value="Whether to skip the spilling of data caused by having maxNumWritersPerBundle.")
    public @Nullable Boolean getNoSpilling() {
        return this.noSpilling;
    }

    @Override
    @SchemaFieldDescription(value="Maximum number of writers created in a bundle before spilling to shuffle.")
    public @Nullable Integer getMaxNumWritersPerBundle() {
        return this.maxNumWritersPerBundle;
    }

    @Override
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public @Nullable ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "TFRecordWriteSchemaTransformConfiguration{outputPrefix=" + this.outputPrefix + ", filenameSuffix=" + this.filenameSuffix + ", numShards=" + this.numShards + ", shardTemplate=" + this.shardTemplate + ", compression=" + this.compression + ", noSpilling=" + this.noSpilling + ", maxNumWritersPerBundle=" + this.maxNumWritersPerBundle + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TFRecordWriteSchemaTransformConfiguration) {
            TFRecordWriteSchemaTransformConfiguration that = (TFRecordWriteSchemaTransformConfiguration)o;
            return this.outputPrefix.equals(that.getOutputPrefix()) && (this.filenameSuffix == null ? that.getFilenameSuffix() == null : this.filenameSuffix.equals(that.getFilenameSuffix())) && this.numShards == that.getNumShards() && (this.shardTemplate == null ? that.getShardTemplate() == null : this.shardTemplate.equals(that.getShardTemplate())) && this.compression.equals(that.getCompression()) && (this.noSpilling == null ? that.getNoSpilling() == null : this.noSpilling.equals(that.getNoSpilling())) && (this.maxNumWritersPerBundle == null ? that.getMaxNumWritersPerBundle() == null : this.maxNumWritersPerBundle.equals(that.getMaxNumWritersPerBundle())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.outputPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.filenameSuffix == null ? 0 : this.filenameSuffix.hashCode();
        h$ *= 1000003;
        h$ ^= this.numShards;
        h$ *= 1000003;
        h$ ^= this.shardTemplate == null ? 0 : this.shardTemplate.hashCode();
        h$ *= 1000003;
        h$ ^= this.compression.hashCode();
        h$ *= 1000003;
        h$ ^= this.noSpilling == null ? 0 : this.noSpilling.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxNumWritersPerBundle == null ? 0 : this.maxNumWritersPerBundle.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends TFRecordWriteSchemaTransformConfiguration.Builder {
        private String outputPrefix;
        private @Nullable String filenameSuffix;
        private Integer numShards;
        private @Nullable String shardTemplate;
        private String compression;
        private @Nullable Boolean noSpilling;
        private @Nullable Integer maxNumWritersPerBundle;
        private @Nullable ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setOutputPrefix(String outputPrefix) {
            if (outputPrefix == null) {
                throw new NullPointerException("Null outputPrefix");
            }
            this.outputPrefix = outputPrefix;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setFilenameSuffix(String filenameSuffix) {
            this.filenameSuffix = filenameSuffix;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setNumShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setShardTemplate(String shardTemplate) {
            this.shardTemplate = shardTemplate;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setCompression(String compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setNoSpilling(Boolean noSpilling) {
            this.noSpilling = noSpilling;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setMaxNumWritersPerBundle(@Nullable Integer maxNumWritersPerBundle) {
            this.maxNumWritersPerBundle = maxNumWritersPerBundle;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public TFRecordWriteSchemaTransformConfiguration build() {
            if (this.outputPrefix == null || this.numShards == null || this.compression == null) {
                StringBuilder missing = new StringBuilder();
                if (this.outputPrefix == null) {
                    missing.append(" outputPrefix");
                }
                if (this.numShards == null) {
                    missing.append(" numShards");
                }
                if (this.compression == null) {
                    missing.append(" compression");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TFRecordWriteSchemaTransformConfiguration(this.outputPrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.compression, this.noSpilling, this.maxNumWritersPerBundle, this.errorHandling);
        }
    }
}

