/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.direct.Clock;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class NanosOffsetClock
implements Clock {
    private final @UnknownKeyFor @NonNull @Initialized long baseMillis = System.currentTimeMillis();
    private final @UnknownKeyFor @NonNull @Initialized long nanosAtBaseMillis = System.nanoTime();

    public static @UnknownKeyFor @NonNull @Initialized NanosOffsetClock create() {
        return new NanosOffsetClock();
    }

    private NanosOffsetClock() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant now() {
        return new Instant(this.baseMillis + TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.nanosAtBaseMillis, TimeUnit.NANOSECONDS));
    }
}

