/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.util.construction.AutoValue_Timer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

@AutoValue
public abstract class Timer<@UnknownKeyFor K> {
    public static <K> @UnknownKeyFor @NonNull @Initialized Timer<K> of(K userKey, @UnknownKeyFor @NonNull @Initialized String dynamicTimerTag, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized Instant fireTimestamp, @UnknownKeyFor @NonNull @Initialized Instant holdTimestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        return new AutoValue_Timer<K>(userKey, dynamicTimerTag, windows, false, fireTimestamp, holdTimestamp, paneInfo);
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Timer<K> cleared(K userKey, @UnknownKeyFor @NonNull @Initialized String dynamicTimerTag, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows) {
        return new AutoValue_Timer<K>(userKey, dynamicTimerTag, windows, true, null, null, null);
    }

    public abstract @Nullable K getUserKey();

    public abstract @UnknownKeyFor @NonNull @Initialized String getDynamicTimerTag();

    public abstract @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean getClearBit();

    public abstract @Nullable @UnknownKeyFor @Initialized Instant getFireTimestamp();

    public abstract @Nullable @UnknownKeyFor @Initialized Instant getHoldTimestamp();

    public abstract @Nullable @UnknownKeyFor @Initialized PaneInfo getPaneInfo();

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public final @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof Timer)) {
            return false;
        }
        Timer that = (Timer)other;
        return Objects.equals(this.getUserKey(), that.getUserKey()) && Objects.equals(this.getDynamicTimerTag(), that.getDynamicTimerTag()) && Objects.equals(this.getWindows(), that.getWindows()) && this.getClearBit() == that.getClearBit() && Objects.equals(this.getFireTimestamp(), that.getFireTimestamp()) && Objects.equals(this.getHoldTimestamp(), that.getHoldTimestamp()) && Objects.equals(this.getPaneInfo(), that.getPaneInfo());
    }

    @Pure
    public final @UnknownKeyFor @NonNull @Initialized int hashCode() {
        if (this.getClearBit()) {
            return Objects.hash(this.getUserKey(), this.getDynamicTimerTag(), this.getClearBit(), this.getWindows());
        }
        return Objects.hash(this.getUserKey(), this.getDynamicTimerTag(), this.getClearBit(), this.getFireTimestamp().getMillis(), this.getHoldTimestamp().getMillis(), this.getWindows(), this.getPaneInfo());
    }

    public static class Coder<@UnknownKeyFor K>
    extends StructuredCoder<Timer<K>> {
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsCoder;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

        public static <K> @UnknownKeyFor @NonNull @Initialized Coder<K> of(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new Coder<K>(keyCoder, windowCoder);
        }

        private Coder(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
            this.keyCoder = keyCoder;
            this.windowsCoder = CollectionCoder.of(windowCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized Timer<K> timer, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.keyCoder.encode(timer.getUserKey(), outStream);
            StringUtf8Coder.of().encode(timer.getDynamicTimerTag(), outStream);
            this.windowsCoder.encode(timer.getWindows(), outStream);
            BooleanCoder.of().encode(timer.getClearBit(), outStream);
            if (!timer.getClearBit()) {
                InstantCoder.of().encode(timer.getFireTimestamp(), outStream);
                InstantCoder.of().encode(timer.getHoldTimestamp(), outStream);
                PaneInfo.PaneInfoCoder.INSTANCE.encode(timer.getPaneInfo(), outStream);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timer<K> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            K userKey = this.keyCoder.decode(inStream);
            String dynamicTimerTag = StringUtf8Coder.of().decode(inStream);
            Collection<? extends BoundedWindow> windows = this.windowsCoder.decode(inStream);
            boolean clearBit = BooleanCoder.of().decode(inStream);
            if (clearBit) {
                return Timer.cleared(userKey, dynamicTimerTag, windows);
            }
            Instant fireTimestamp = InstantCoder.of().decode(inStream);
            Instant holdTimestamp = InstantCoder.of().decode(inStream);
            PaneInfo paneInfo = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            return Timer.of(userKey, dynamicTimerTag, windows, fireTimestamp, holdTimestamp, paneInfo);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.keyCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return Arrays.asList(this.keyCoder, this.windowCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindowCoder() {
            return this.windowCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> getWindowsCoder() {
            return this.windowsCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> getValueCoder() {
            return this.keyCoder;
        }

        @Override
        public void verifyDeterministic() throws  @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            Coder.verifyDeterministic(this, "UserKey coder must be deterministic", this.keyCoder);
            Coder.verifyDeterministic(this, "Window coder must be deterministic", this.windowCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized Timer<K> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.keyCoder.registerByteSizeObserver(value.getUserKey(), observer);
            StringUtf8Coder.of().registerByteSizeObserver(value.getDynamicTimerTag(), observer);
            this.windowsCoder.registerByteSizeObserver(value.getWindows(), observer);
            BooleanCoder.of().registerByteSizeObserver(value.getClearBit(), observer);
            if (!value.getClearBit()) {
                InstantCoder.of().registerByteSizeObserver(value.getFireTimestamp(), observer);
                InstantCoder.of().registerByteSizeObserver(value.getHoldTimestamp(), observer);
                PaneInfo.PaneInfoCoder.INSTANCE.registerByteSizeObserver(value.getPaneInfo(), observer);
            }
        }
    }
}

