/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.DoFnWithExecutionInformation;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.construction.AutoValue_ParDoTranslation_ParDoLikeTimerFamilySpecs;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.CombineTranslation;
import org.apache.beam.sdk.util.construction.PCollectionViewTranslation;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ParDoTranslation {
    public static final @UnknownKeyFor @NonNull @Initialized String REQUIRES_STATEFUL_PROCESSING_URN = "beam:requirement:pardo:stateful:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REQUIRES_BUNDLE_FINALIZATION_URN = "beam:requirement:pardo:finalization:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REQUIRES_STABLE_INPUT_URN = "beam:requirement:pardo:stable_input:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REQUIRES_TIME_SORTED_INPUT_URN = "beam:requirement:pardo:time_sorted_input:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REQUIRES_SPLITTABLE_DOFN_URN = "beam:requirement:pardo:splittable_dofn:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REQUIRES_ON_WINDOW_EXPIRATION_URN = "beam:requirement:pardo:on_window_expiration:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String BAG_USER_STATE = "beam:user_state:bag:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String MULTIMAP_USER_STATE = "beam:user_state:multimap:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String ORDERED_LIST_USER_STATE = "beam:user_state:ordered_list:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String CUSTOM_JAVA_DO_FN_URN = "beam:dofn:javasdk:0.1";
    public static final @UnknownKeyFor @NonNull @Initialized String CUSTOM_JAVA_VIEW_FN_URN = "beam:viewfn:javasdk:0.1";
    public static final @UnknownKeyFor @NonNull @Initialized String CUSTOM_JAVA_WINDOW_MAPPING_FN_URN = "beam:windowmappingfn:javasdk:0.1";

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload translateParDo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> appliedPTransform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ParDo.MultiOutput<?, ?> parDo = appliedPTransform.getTransform();
        Pipeline pipeline = appliedPTransform.getPipeline();
        DoFn<?, ?> doFn = parDo.getFn();
        Set allInputs = appliedPTransform.getInputs().keySet().stream().map(TupleTag::getId).collect(Collectors.toSet());
        Set sideInputs = parDo.getSideInputs().values().stream().map(s -> s.getTagInternal().getId()).collect(Collectors.toSet());
        String mainInputName = (String)Iterables.getOnlyElement((Iterable)Sets.difference(allInputs, sideInputs));
        PCollection<?> mainInput = appliedPTransform.getInputs().get(new TupleTag(mainInputName));
        DoFnSchemaInformation doFnSchemaInformation = ParDo.getDoFnSchemaInformation(doFn, mainInput);
        return ParDoTranslation.translateParDo(parDo, mainInput, doFnSchemaInformation, pipeline, components);
    }

    public static <InputT> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload translateParDo(final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> parDo, @UnknownKeyFor @NonNull @Initialized PCollection<InputT> mainInput, final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, final @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Coder keyCoder;
        String restrictionCoderId;
        final DoFn<InputT, ?> doFn = parDo.getFn();
        final DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.processElement().isSplittable()) {
            DoFnInvoker<InputT, ?> doFnInvoker = DoFnInvokers.invokerFor(doFn);
            KvCoder restrictionAndWatermarkStateCoder = KvCoder.of(doFnInvoker.invokeGetRestrictionCoder(pipeline.getCoderRegistry()), doFnInvoker.invokeGetWatermarkEstimatorStateCoder(pipeline.getCoderRegistry()));
            restrictionCoderId = components.registerCoder(restrictionAndWatermarkStateCoder);
        } else {
            restrictionCoderId = "";
        }
        final Coder<?> windowCoder = mainInput.getWindowingStrategy().getWindowFn().windowCoder();
        if (signature.usesState() || signature.usesTimers()) {
            Preconditions.checkArgument((boolean)(mainInput.getCoder() instanceof KvCoder), (String)"DoFn's that use state or timers must have an input PCollection with a KvCoder but received %s", mainInput.getCoder());
            keyCoder = ((KvCoder)mainInput.getCoder()).getKeyCoder();
        } else {
            keyCoder = null;
        }
        return ParDoTranslation.payloadForParDoLike(new ParDoLike(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateDoFn(@UnknownKeyFor @NonNull @Initialized SdkComponents newComponents) {
                return ParDoTranslation.translateDoFn(parDo.getFn(), parDo.getMainOutputTag(), parDo.getSideInputs(), doFnSchemaInformation, newComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.SideInput> translateSideInputs(@UnknownKeyFor @NonNull @Initialized SdkComponents components2) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView<?> sideInput : parDo.getSideInputs().values()) {
                    sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components2));
                }
                return sideInputs;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec> translateStateSpecs(@UnknownKeyFor @NonNull @Initialized SdkComponents components2) throws @UnknownKeyFor @NonNull @Initialized IOException {
                HashMap<String, RunnerApi.StateSpec> stateSpecs = new HashMap<String, RunnerApi.StateSpec>();
                for (Map.Entry<String, DoFnSignature.StateDeclaration> state : signature.stateDeclarations().entrySet()) {
                    RunnerApi.StateSpec spec = ParDoTranslation.translateStateSpec(DoFnSignatures.getStateSpecOrThrow(state.getValue(), doFn), components2);
                    stateSpecs.put(state.getKey(), spec);
                }
                return stateSpecs;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ParDoLikeTimerFamilySpecs translateTimerFamilySpecs(@UnknownKeyFor @NonNull @Initialized SdkComponents newComponents) {
                RunnerApi.TimerFamilySpec spec;
                HashMap<String, RunnerApi.TimerFamilySpec> timerFamilySpecs = new HashMap<String, RunnerApi.TimerFamilySpec>();
                for (Map.Entry<String, DoFnSignature.TimerDeclaration> entry : signature.timerDeclarations().entrySet()) {
                    spec = ParDoTranslation.translateTimerFamilySpec(DoFnSignatures.getTimerSpecOrThrow(entry.getValue(), doFn), newComponents, keyCoder, windowCoder);
                    timerFamilySpecs.put(entry.getKey(), spec);
                }
                for (Map.Entry<String, Object> entry : signature.timerFamilyDeclarations().entrySet()) {
                    spec = ParDoTranslation.translateTimerFamilySpec(DoFnSignatures.getTimerFamilySpecOrThrow((DoFnSignature.TimerFamilyDeclaration)entry.getValue(), doFn), newComponents, keyCoder, windowCoder);
                    timerFamilySpecs.put(entry.getKey(), spec);
                }
                String onWindowExpirationTimerFamilySpec = null;
                if (signature.onWindowExpiration() != null) {
                    RunnerApi.TimerFamilySpec timerFamilySpec = RunnerApi.TimerFamilySpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(TimeDomain.EVENT_TIME)).setTimerFamilyCoderId(ParDoTranslation.registerCoderOrThrow(components, Timer.Coder.of(keyCoder, windowCoder))).build();
                    for (int i = 0; i < Integer.MAX_VALUE && timerFamilySpecs.containsKey(onWindowExpirationTimerFamilySpec = "onWindowExpiration" + i); ++i) {
                    }
                    timerFamilySpecs.put(onWindowExpirationTimerFamilySpec, timerFamilySpec);
                }
                return ParDoLikeTimerFamilySpecs.create(timerFamilySpecs, onWindowExpirationTimerFamilySpec);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isStateful() {
                return !signature.stateDeclarations().isEmpty() || !signature.timerDeclarations().isEmpty() || !signature.timerFamilyDeclarations().isEmpty() || signature.onWindowExpiration() != null;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isSplittable() {
                return signature.processElement().isSplittable();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isRequiresStableInput() {
                return signature.processElement().requiresStableInput();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isRequiresTimeSortedInput() {
                return signature.processElement().requiresTimeSortedInput();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean requestsFinalization() {
                return signature.startBundle() != null && signature.startBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.processElement() != null && signature.processElement().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.finishBundle() != null && signature.finishBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String translateRestrictionCoderId(@UnknownKeyFor @NonNull @Initialized SdkComponents newComponents) {
                return restrictionCoderId;
            }
        }, components);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> getDoFn(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload payload) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getDoFn();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> getDoFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getFn();
        }
        return ParDoTranslation.getDoFn(ParDoTranslation.getParDoPayload(application));
    }

    public static @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation getSchemaInformation(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        try {
            return ParDoTranslation.getSchemaInformation(ParDoTranslation.getParDoPayload(application));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation getSchemaInformation(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
        try {
            return ParDoTranslation.getSchemaInformation(ParDoTranslation.getParDoPayload(pTransform));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation getSchemaInformation(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload payload) {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getSchemaInformation();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> getMainOutputTag(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload payload) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getMainOutputTag();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> getSideInputMapping(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        try {
            return ParDoTranslation.getSideInputMapping(ParDoTranslation.getParDoPayload(application));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> getSideInputMapping(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
        try {
            return ParDoTranslation.getSideInputMapping(ParDoTranslation.getParDoPayload(pTransform));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> getSideInputMapping(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload payload) {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getSideInputMapping();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> getMainOutputTag(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getMainOutputTag();
        }
        return ParDoTranslation.getMainOutputTag(ParDoTranslation.getParDoPayload(application));
    }

    public static @UnknownKeyFor @NonNull @Initialized TupleTagList getAdditionalOutputTags(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getAdditionalOutputTags();
        }
        RunnerApi.PTransform protoTransform = PTransformTranslation.toProto(application, SdkComponents.create(application.getPipeline().getOptions()));
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)protoTransform.getSpec().getPayload());
        TupleTag<?> mainOutputTag = ParDoTranslation.getMainOutputTag(payload);
        Sets.SetView outputTags = Sets.difference(protoTransform.getOutputsMap().keySet(), Collections.singleton(mainOutputTag.getId()));
        ArrayList additionalOutputTags = new ArrayList();
        for (String outputTag : outputTags) {
            additionalOutputTags.add(new TupleTag(outputTag));
        }
        return TupleTagList.of(additionalOutputTags);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> getOutputCoders(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        return application.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> getSideInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getSideInputs().values().stream().collect(Collectors.toList());
        }
        SdkComponents sdkComponents = SdkComponents.create(application.getPipeline().getOptions());
        RunnerApi.PTransform parDoProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDoProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = (String)sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = (RunnerApi.SideInput)sideInputEntry.getValue();
            PCollection originalPCollection = (PCollection)Preconditions.checkNotNull(application.getInputs().get(new TupleTag(sideInputTag)), (String)"no input with tag %s", (Object)sideInputTag);
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, parDoProto, components));
        }
        return views;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PCollection getMainInput(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform ptransform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument(("beam:transform:pardo:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_truncate_sized_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_elements:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(ptransform.getSpec().getUrn()) ? 1 : 0) != 0, (String)"Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        return components.getPcollectionsOrThrow(ptransform.getInputsOrThrow(ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)ptransform)));
    }

    public static @UnknownKeyFor @NonNull @Initialized String getMainInputName(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransformOrBuilder ptransform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument(("beam:transform:pardo:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_truncate_sized_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_elements:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(ptransform.getSpec().getUrn()) ? 1 : 0) != 0, (String)"Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)ptransform.getSpec().getPayload());
        return ParDoTranslation.getMainInputName(ptransform, payload);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getMainInputName(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransformOrBuilder ptransform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload payload) {
        return (String)Iterables.getOnlyElement((Iterable)Sets.difference(ptransform.getInputsMap().keySet(), (Set)Sets.union(payload.getSideInputsMap().keySet(), payload.getTimerFamilySpecsMap().keySet())));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec translateStateSpec(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> stateSpec, final @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        final RunnerApi.StateSpec.Builder builder = RunnerApi.StateSpec.newBuilder();
        return stateSpec.match(new StateSpec.Cases<RunnerApi.StateSpec>(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchValue(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
                return builder.setReadModifyWriteSpec(RunnerApi.ReadModifyWriteStateSpec.newBuilder().setCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.BAG_USER_STATE)).build();
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchBag(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> elementCoder) {
                return builder.setBagSpec(RunnerApi.BagStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.BAG_USER_STATE)).build();
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchOrderedList(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> elementCoder) {
                return builder.setOrderedListSpec(RunnerApi.OrderedListStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.ORDERED_LIST_USER_STATE)).build();
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchCombining(/*
             * Issues handling annotations - annotations may be inaccurate
             */
             @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> combineFn, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> accumCoder) {
                return builder.setCombiningSpec(RunnerApi.CombiningStateSpec.newBuilder().setAccumulatorCoderId(ParDoTranslation.registerCoderOrThrow(components, accumCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.BAG_USER_STATE)).build();
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchMap(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
                return builder.setMapSpec(RunnerApi.MapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.MULTIMAP_USER_STATE)).build();
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchSet(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> elementCoder) {
                return builder.setSetSpec(RunnerApi.SetStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.MULTIMAP_USER_STATE)).build();
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec dispatchMultimap(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
                return builder.setMultimapSpec(RunnerApi.MultimapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).setProtocol(RunnerApi.FunctionSpec.newBuilder().setUrn(ParDoTranslation.MULTIMAP_USER_STATE)).build();
            }
        });
    }

    @VisibleForTesting
    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> fromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec stateSpec, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        switch (stateSpec.getSpecCase()) {
            case READ_MODIFY_WRITE_SPEC: {
                return StateSpecs.value(components.getCoder(stateSpec.getReadModifyWriteSpec().getCoderId()));
            }
            case BAG_SPEC: {
                return StateSpecs.bag(components.getCoder(stateSpec.getBagSpec().getElementCoderId()));
            }
            case COMBINING_SPEC: {
                RunnerApi.FunctionSpec combineFnSpec = stateSpec.getCombiningSpec().getCombineFn();
                if (!combineFnSpec.getUrn().equals("beam:combinefn:javasdk:v1")) {
                    throw new UnsupportedOperationException(String.format("Cannot create %s from non-Java %s: %s", StateSpec.class.getSimpleName(), Combine.CombineFn.class.getSimpleName(), combineFnSpec.getUrn()));
                }
                Combine.CombineFn combineFn = (Combine.CombineFn)SerializableUtils.deserializeFromByteArray(combineFnSpec.getPayload().toByteArray(), Combine.CombineFn.class.getSimpleName());
                return StateSpecs.combining(components.getCoder(stateSpec.getCombiningSpec().getAccumulatorCoderId()), combineFn);
            }
            case MAP_SPEC: {
                return StateSpecs.map(components.getCoder(stateSpec.getMapSpec().getKeyCoderId()), components.getCoder(stateSpec.getMapSpec().getValueCoderId()));
            }
            case SET_SPEC: {
                return StateSpecs.set(components.getCoder(stateSpec.getSetSpec().getElementCoderId()));
            }
            case ORDERED_LIST_SPEC: {
                return StateSpecs.orderedList(components.getCoder(stateSpec.getOrderedListSpec().getElementCoderId()));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", RunnerApi.StateSpec.class.getName(), stateSpec));
    }

    public static @UnknownKeyFor @NonNull @Initialized String registerCoderOrThrow(@UnknownKeyFor @NonNull @Initialized SdkComponents components, @UnknownKeyFor @NonNull @Initialized Coder coder) {
        try {
            return components.registerCoder(coder);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failure to register coder", exc);
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TimerFamilySpec translateTimerFamilySpec(@UnknownKeyFor @NonNull @Initialized TimerSpec timer, @UnknownKeyFor @NonNull @Initialized SdkComponents components, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        return RunnerApi.TimerFamilySpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(timer.getTimeDomain())).setTimerFamilyCoderId(ParDoTranslation.registerCoderOrThrow(components, Timer.Coder.of(keyCoder, windowCoder))).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TimeDomain.Enum translateTimeDomain(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        switch (timeDomain) {
            case EVENT_TIME: {
                return RunnerApi.TimeDomain.Enum.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.PROCESSING_TIME;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                throw new IllegalArgumentException(String.format("%s is not permitted for user timers", TimeDomain.SYNCHRONIZED_PROCESSING_TIME.name()));
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateDoFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> tag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_DO_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(DoFnWithExecutionInformation.of(fn, tag, sideInputMapping, doFnSchemaInformation)))).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized DoFnWithExecutionInformation doFnWithExecutionInformationFromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec fnSpec) {
        Preconditions.checkArgument((boolean)fnSpec.getUrn().equals(CUSTOM_JAVA_DO_FN_URN), (String)"Expected %s to be %s with URN %s, but URN was %s", (Object)DoFn.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)CUSTOM_JAVA_DO_FN_URN, (Object)fnSpec.getUrn());
        byte[] serializedFn = fnSpec.getPayload().toByteArray();
        return (DoFnWithExecutionInformation)SerializableUtils.deserializeFromByteArray(serializedFn, "Custom DoFn With Execution Info");
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.SideInput> translateSideInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
        for (PCollectionView<?> sideInput : views) {
            sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
        }
        return sideInputs;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.SideInput translateView(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        RunnerApi.SideInput.Builder builder = RunnerApi.SideInput.newBuilder();
        builder.setAccessPattern(RunnerApi.FunctionSpec.newBuilder().setUrn(view.getViewFn().getMaterialization().getUrn()).build());
        builder.setViewFn(ParDoTranslation.translateViewFn(view.getViewFn(), components));
        builder.setWindowMappingFn(ParDoTranslation.translateWindowMappingFn(view.getWindowMappingFn(), components));
        return builder.build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateViewFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ViewFn<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> viewFn, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_VIEW_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(viewFn))).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload getParDoPayload(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        RunnerApi.PTransform parDoPTransform = PTransformTranslation.toProto(transform, Collections.emptyList(), components);
        return ParDoTranslation.getParDoPayload(parDoPTransform);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload getParDoPayload(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform parDoPTransform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return RunnerApi.ParDoPayload.parseFrom((ByteString)parDoPTransform.getSpec().getPayload());
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean usesStateOrTimers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getStateSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isSplittable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return !payload.getRestrictionCoderId().isEmpty();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateWindowMappingFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowMappingFn, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(windowMappingFn))).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ParDoPayload payloadForParDoLike(@UnknownKeyFor @NonNull @Initialized ParDoLike parDo, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (parDo.isStateful()) {
            components.addRequirement(REQUIRES_STATEFUL_PROCESSING_URN);
        }
        if (parDo.isSplittable()) {
            components.addRequirement(REQUIRES_SPLITTABLE_DOFN_URN);
        }
        if (parDo.requestsFinalization()) {
            components.addRequirement(REQUIRES_BUNDLE_FINALIZATION_URN);
        }
        if (parDo.isRequiresStableInput()) {
            components.addRequirement(REQUIRES_STABLE_INPUT_URN);
        }
        if (parDo.isRequiresTimeSortedInput()) {
            components.addRequirement(REQUIRES_TIME_SORTED_INPUT_URN);
        }
        ParDoLikeTimerFamilySpecs timerFamilySpecs = parDo.translateTimerFamilySpecs(components);
        RunnerApi.ParDoPayload.Builder builder = RunnerApi.ParDoPayload.newBuilder().setDoFn(parDo.translateDoFn(components)).putAllStateSpecs(parDo.translateStateSpecs(components)).putAllTimerFamilySpecs(timerFamilySpecs.timerFamilySpecs()).putAllSideInputs(parDo.translateSideInputs(components)).setRequiresStableInput(parDo.isRequiresStableInput()).setRequiresTimeSortedInput(parDo.isRequiresTimeSortedInput()).setRestrictionCoderId(parDo.translateRestrictionCoderId(components)).setRequestsFinalization(parDo.requestsFinalization());
        if (timerFamilySpecs.onWindowExpirationTimerFamilySpec() != null) {
            components.addRequirement(REQUIRES_ON_WINDOW_EXPIRATION_URN);
            builder.setOnWindowExpirationTimerFamilySpec(timerFamilySpecs.onWindowExpirationTimerFamilySpec());
        }
        return builder.build();
    }

    static {
        Preconditions.checkState((boolean)REQUIRES_STATEFUL_PROCESSING_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRequirements.Enum.REQUIRES_STATEFUL_PROCESSING)));
        Preconditions.checkState((boolean)REQUIRES_BUNDLE_FINALIZATION_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRequirements.Enum.REQUIRES_BUNDLE_FINALIZATION)));
        Preconditions.checkState((boolean)REQUIRES_STABLE_INPUT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRequirements.Enum.REQUIRES_STABLE_INPUT)));
        Preconditions.checkState((boolean)REQUIRES_TIME_SORTED_INPUT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRequirements.Enum.REQUIRES_TIME_SORTED_INPUT)));
        Preconditions.checkState((boolean)REQUIRES_SPLITTABLE_DOFN_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRequirements.Enum.REQUIRES_SPLITTABLE_DOFN)));
        Preconditions.checkState((boolean)REQUIRES_ON_WINDOW_EXPIRATION_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRequirements.Enum.REQUIRES_ON_WINDOW_EXPIRATION)));
        Preconditions.checkState((boolean)BAG_USER_STATE.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardUserStateTypes.Enum.BAG)));
        Preconditions.checkState((boolean)MULTIMAP_USER_STATE.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardUserStateTypes.Enum.MULTIMAP)));
        Preconditions.checkState((boolean)ORDERED_LIST_USER_STATE.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardUserStateTypes.Enum.ORDERED_LIST)));
    }

    public static interface ParDoLike {
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateDoFn(@UnknownKeyFor @NonNull @Initialized SdkComponents var1);

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.SideInput> translateSideInputs(@UnknownKeyFor @NonNull @Initialized SdkComponents var1);

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec> translateStateSpecs(@UnknownKeyFor @NonNull @Initialized SdkComponents var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

        public @UnknownKeyFor @NonNull @Initialized ParDoLikeTimerFamilySpecs translateTimerFamilySpecs(@UnknownKeyFor @NonNull @Initialized SdkComponents var1);

        public @UnknownKeyFor @NonNull @Initialized boolean isStateful();

        public @UnknownKeyFor @NonNull @Initialized boolean isSplittable();

        public @UnknownKeyFor @NonNull @Initialized boolean isRequiresStableInput();

        public @UnknownKeyFor @NonNull @Initialized boolean isRequiresTimeSortedInput();

        public @UnknownKeyFor @NonNull @Initialized boolean requestsFinalization();

        public @UnknownKeyFor @NonNull @Initialized String translateRestrictionCoderId(@UnknownKeyFor @NonNull @Initialized SdkComponents var1);
    }

    @AutoValue
    public static abstract class ParDoLikeTimerFamilySpecs {
        public static @UnknownKeyFor @NonNull @Initialized ParDoLikeTimerFamilySpecs create(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.TimerFamilySpec> timerFamilySpecs, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String onWindowExpirationTimerFamilySpec) {
            return new AutoValue_ParDoTranslation_ParDoLikeTimerFamilySpecs(timerFamilySpecs, onWindowExpirationTimerFamilySpec);
        }

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.TimerFamilySpec> timerFamilySpecs();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String onWindowExpirationTimerFamilySpec();
    }

    public static class ParDoTranslator
    implements PTransformTranslation.TransformTranslator<ParDo.MultiOutput<?, ?>> {
        public static @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformTranslator create() {
            return new ParDoTranslator();
        }

        private ParDoTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> transform) {
            return "beam:transform:pardo:v1";
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> pTransform) {
            return pTransform instanceof ParDo.MultiOutput;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            RunnerApi.PTransform.Builder builder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            AppliedPTransform<?, ?, ?> appliedParDo = appliedPTransform;
            RunnerApi.ParDoPayload payload = ParDoTranslation.translateParDo(appliedParDo, components);
            builder.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:pardo:v1").setPayload(payload.toByteString()).build());
            builder.setEnvironmentId(components.getEnvironmentIdFor(appliedParDo.getResourceHints()));
            return builder.build();
        }
    }
}

