/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.local;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public abstract class StructuralKey<@UnknownKeyFor K> {
    private StructuralKey() {
    }

    public abstract K getKey();

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> empty() {
        return new StructuralKey<Object>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object getKey() {
                return this;
            }
        };
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized StructuralKey<K> of(K key, @UnknownKeyFor @NonNull @Initialized Coder<K> coder) {
        try {
            return new CoderStructuralKey(coder, key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not encode a key with its provided coder " + coder.getClass().getSimpleName(), e);
        }
    }

    private static class CoderStructuralKey<@UnknownKeyFor K>
    extends StructuralKey<K> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> coder;
        private final K key;
        private @UnknownKeyFor @NonNull @Initialized byte @MonotonicNonNull @UnknownKeyFor @Initialized [] encoded;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Object structuralValue;

        private CoderStructuralKey(@UnknownKeyFor @NonNull @Initialized Coder<K> coder, K key) {
            this.coder = coder;
            this.key = key;
        }

        private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getEncoded() throws @UnknownKeyFor @NonNull @Initialized CoderException {
            if (this.encoded == null) {
                this.encoded = CoderUtils.encodeToByteArray(this.coder, this.key);
            }
            return this.encoded;
        }

        private @UnknownKeyFor @NonNull @Initialized Object getStructuralValue() {
            if (this.structuralValue == null) {
                this.structuralValue = this.coder.structuralValue(this.key);
            }
            return this.structuralValue;
        }

        @Override
        public K getKey() {
            try {
                return CoderUtils.decodeFromByteArray(this.coder, this.getEncoded());
            }
            catch (CoderException e) {
                throw new IllegalArgumentException("Could not decode Key with coder of type " + this.coder.getClass().getSimpleName(), e);
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CoderStructuralKey) {
                CoderStructuralKey that = (CoderStructuralKey)other;
                return this.getStructuralValue().equals(that.getStructuralValue());
            }
            return false;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.getStructuralValue().hashCode();
        }
    }
}

