/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.core.MergingStateAccessor;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.GroupingState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StateMerging {
    public static <K, StateT extends State, W extends BoundedWindow> void clear(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context, @UnknownKeyFor @NonNull @Initialized StateTag<StateT> address) {
        for (State state : context.accessInEachMergingWindow(address).values()) {
            state.clear();
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public static <K, T, W extends BoundedWindow> void prefetchBags(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context, @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> address) {
        Map<W, BagState<T>> map = context.accessInEachMergingWindow(address);
        if (map.isEmpty()) {
            return;
        }
        BagState<T> result = context.access(address);
        for (BagState<T> source : map.values()) {
            if (source.equals(result)) continue;
            StateMerging.prefetchRead(source);
        }
    }

    public static <K, T, W extends BoundedWindow> void mergeBags(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context, @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> address) {
        StateMerging.mergeBags(context.accessInEachMergingWindow(address).values(), context.access(address));
    }

    public static <T> void mergeBags(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BagState<T>> sources, @UnknownKeyFor @NonNull @Initialized BagState<T> result) {
        if (sources.isEmpty()) {
            return;
        }
        ArrayList<BagState<T>> futures = new ArrayList<BagState<T>>(sources.size());
        for (BagState<T> bagState : sources) {
            if (bagState.equals(result)) continue;
            StateMerging.prefetchRead(bagState);
            futures.add(bagState);
        }
        if (futures.isEmpty()) {
            return;
        }
        for (ReadableState readableState : futures) {
            for (Object element : (Iterable)readableState.read()) {
                result.add(element);
            }
        }
        for (BagState<Object> bagState : sources) {
            if (bagState.equals(result)) continue;
            bagState.clear();
        }
    }

    public static <K, T, W extends BoundedWindow> void mergeSets(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context, @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<T>> address) {
        StateMerging.mergeSets(context.accessInEachMergingWindow(address).values(), context.access(address));
    }

    public static <T> void mergeSets(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SetState<T>> sources, @UnknownKeyFor @NonNull @Initialized SetState<T> result) {
        if (sources.isEmpty()) {
            return;
        }
        ArrayList<SetState<T>> futures = new ArrayList<SetState<T>>(sources.size());
        for (SetState<T> setState : sources) {
            if (setState.equals(result)) continue;
            StateMerging.prefetchRead(setState);
            futures.add(setState);
        }
        if (futures.isEmpty()) {
            return;
        }
        for (ReadableState readableState : futures) {
            for (Object element : (Iterable)readableState.read()) {
                result.add(element);
            }
        }
        for (SetState<Object> setState : sources) {
            if (setState.equals(result)) continue;
            setState.clear();
        }
    }

    public static <K, StateT extends GroupingState<?, ?>, W extends BoundedWindow> void prefetchCombiningValues(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context, @UnknownKeyFor @NonNull @Initialized StateTag<StateT> address) {
        for (GroupingState state : context.accessInEachMergingWindow(address).values()) {
            StateMerging.prefetchRead(state);
        }
    }

    public static <K, InputT, AccumT, OutputT, W extends BoundedWindow> void mergeCombiningValues(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context, @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address) {
        StateMerging.mergeCombiningValues(context.accessInEachMergingWindow(address).values(), context.access(address));
    }

    public static <InputT, AccumT, OutputT> void mergeCombiningValues(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> sources, @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> result) {
        if (sources.isEmpty()) {
            return;
        }
        if (sources.size() == 1 && sources.contains(result)) {
            return;
        }
        ArrayList futures = new ArrayList(sources.size());
        for (CombiningState<InputT, AccumT, OutputT> combiningState : sources) {
            StateMerging.prefetchRead(combiningState);
        }
        ArrayList<AccumT> accumulators = new ArrayList<AccumT>(futures.size());
        for (CombiningState<InputT, AccumT, OutputT> combiningState : sources) {
            accumulators.add(combiningState.getAccum());
        }
        Object e = result.mergeAccumulators(accumulators);
        for (CombiningState<InputT, AccumT, OutputT> source : sources) {
            source.clear();
        }
        result.addAccum(e);
    }

    private static void prefetchRead(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> source) {
        source.readLater();
    }
}

