/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.test;

import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.batchlet.BatchletStepController;
import org.apache.batchee.container.impl.controller.chunk.ChunkStepController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.modelresolver.PropertyResolverFactory;
import org.apache.batchee.container.navigator.JobNavigator;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ListenerFactory;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.services.persistence.MemoryPersistenceManagerService;
import org.apache.batchee.jaxb.Batchlet;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.JSLProperties;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.apache.batchee.spi.PersistenceManagerService;
import org.apache.batchee.spi.SecurityService;

public class StepLauncher {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final JSLProperties EMPTY_JSL_PROPERTIES = new JSLProperties();
    private static final JSLJob EMPTY_JOB = new JSLJob();
    private static final Properties TEST_PROPERTIES = new Properties();

    public static StepExecution execute(Step step) {
        return StepLauncher.execute(step, EMPTY_PROPERTIES);
    }

    public static StepExecution execute(Step step, Properties jobParams) {
        ServicesManager manager = new ServicesManager();
        manager.init(TEST_PROPERTIES);
        PersistenceManagerService persistenceManagerService = (PersistenceManagerService)manager.service(PersistenceManagerService.class);
        BatchArtifactFactory factory = (BatchArtifactFactory)manager.service(BatchArtifactFactory.class);
        JobInstance jobInstance = persistenceManagerService.createJobInstance(step.getId(), ((SecurityService)manager.service(SecurityService.class)).getLoggedUser(), null);
        ((JobStatusManagerService)manager.service(JobStatusManagerService.class)).createJobStatus(jobInstance.getInstanceId());
        JobContextImpl jobContext = new JobContextImpl((ModelNavigator)new JobNavigator(EMPTY_JOB), EMPTY_JSL_PROPERTIES);
        StepContextImpl stepContext = new StepContextImpl(step.getId());
        RuntimeJobExecution runtimeJobExecution = persistenceManagerService.createJobExecution(jobInstance, EMPTY_PROPERTIES, BatchStatus.STARTED);
        InjectionReferences injectionRefs = new InjectionReferences((JobContext)jobContext, (StepContext)stepContext, EMPTY_JSL_PROPERTIES.getPropertyList());
        ListenerFactory listenerFactory = new ListenerFactory(factory, EMPTY_JOB, injectionRefs, runtimeJobExecution);
        runtimeJobExecution.setListenerFactory(listenerFactory);
        runtimeJobExecution.prepareForExecution(jobContext, null);
        if (step.getChunk() != null) {
            step.setChunk((Chunk)PropertyResolverFactory.createChunkPropertyResolver((boolean)false).substituteProperties((Object)step.getChunk(), jobParams));
            new ChunkStepController(runtimeJobExecution, step, stepContext, jobInstance.getInstanceId(), new ArrayBlockingQueue(1), manager).execute();
        } else {
            step.setBatchlet((Batchlet)PropertyResolverFactory.createBatchletPropertyResolver((boolean)false).substituteProperties((Object)step.getBatchlet(), jobParams));
            new BatchletStepController(runtimeJobExecution, step, stepContext, jobInstance.getInstanceId(), new ArrayBlockingQueue(1), manager).execute();
        }
        return persistenceManagerService.getStepExecutionByStepExecutionId(stepContext.getStepInternalExecID());
    }

    private StepLauncher() {
    }

    static {
        TEST_PROPERTIES.put(PersistenceManagerService.class.getName(), MemoryPersistenceManagerService.class.getName());
    }
}

